# Generated by Django 2.1.7 on 2019-03-04 21:39

import datetime
from decimal import Decimal

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("invoices", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="LoggedCost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="created at"
                    ),
                ),
                (
                    "rendered_on",
                    models.DateField(
                        default=datetime.date.today, verbose_name="rendered on"
                    ),
                ),
                (
                    "cost",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=10,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="cost",
                    ),
                ),
                (
                    "third_party_costs",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Total incl. tax for third-party services.",
                        max_digits=10,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="third party costs",
                    ),
                ),
                ("description", models.TextField(verbose_name="description")),
                (
                    "archived_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="archived at"
                    ),
                ),
            ],
            options={
                "verbose_name": "logged cost",
                "verbose_name_plural": "logged costs",
                "ordering": ("-rendered_on", "-created_at"),
            },
        ),
        migrations.CreateModel(
            name="LoggedHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="created at"
                    ),
                ),
                (
                    "rendered_on",
                    models.DateField(
                        default=datetime.date.today, verbose_name="rendered on"
                    ),
                ),
                (
                    "hours",
                    models.DecimalField(
                        decimal_places=1,
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(Decimal("0.1"))
                        ],
                        verbose_name="hours",
                    ),
                ),
                ("description", models.TextField(verbose_name="description")),
                (
                    "archived_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="archived at"
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="created by",
                    ),
                ),
                (
                    "invoice",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="invoices.Invoice",
                        verbose_name="invoice",
                    ),
                ),
                (
                    "rendered_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="loggedhours",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="rendered by",
                    ),
                ),
            ],
            options={
                "verbose_name": "logged hours",
                "verbose_name_plural": "logged hours",
                "ordering": ("-rendered_on", "-created_at"),
            },
        ),
    ]
