# Generated by Django 2.2.5 on 2019-09-15 10:22

from django.db import migrations

from workbench.accounts.middleware import set_user_name


def forwards(apps, schema_editor):
    set_user_name("Migrations")
    LoggedCost = apps.get_model("logbook", "LoggedCost")
    Service = apps.get_model("projects", "Service")

    project_ids_with_costs_without_services = set(
        LoggedCost.objects.filter(service_id__isnull=True).values_list(
            "project_id", flat=True
        )
    )

    for project_id in project_ids_with_costs_without_services:
        service = Service.objects.create(
            project_id=project_id,
            title="Keine Leistung",
            position=-1,
            allow_logging=False,
        )
        LoggedCost.objects.filter(project=project_id, service__isnull=True).update(
            service=service
        )


class Migration(migrations.Migration):

    dependencies = [
        ("logbook", "0012_auto_20190913_0919"),
        ("projects", "0016_auto_20190915_1249"),
    ]

    operations = [migrations.RunPython(forwards)]
