# Generated by Django 3.0.6 on 2020-05-11 11:24

import datetime as dt

from django.db import migrations, models
from django.utils import timezone


def forwards(apps, schema_editor):
    for brk in apps.get_model("logbook", "break").objects.all():
        brk._starts_at = timezone.make_aware(
            dt.datetime.combine(brk.day, brk.starts_at)
        )
        brk._ends_at = timezone.make_aware(dt.datetime.combine(brk.day, brk.ends_at))
        brk.save()


class Migration(migrations.Migration):

    dependencies = [
        ("logbook", "0017_break"),
    ]

    operations = [
        migrations.AddField(
            model_name="break",
            name="_ends_at",
            field=models.DateTimeField(null=True, verbose_name="ends_at"),
        ),
        migrations.AddField(
            model_name="break",
            name="_starts_at",
            field=models.DateTimeField(null=True, verbose_name="starts_at"),
        ),
        migrations.RunPython(forwards),
    ]
