# Generated by Django 3.1.2 on 2020-11-02 08:00

from django.db import migrations, models

from workbench.tools import search


def forwards(apps, schema_editor):
    Model = apps.get_model("offers.Offer")
    for instance in Model.objects.select_related("project"):
        instance._fts = " ".join(
            str(part)
            for part in [
                "%s-%04d-o%02d"
                % (
                    instance.project.created_at.year,
                    instance.project._code,
                    instance._code,
                ),
                instance.project._fts,
            ]
        )
        instance.save()


class Migration(migrations.Migration):

    dependencies = [
        ("offers", "0009_offer_valid_until"),
    ]

    operations = [
        migrations.AddField(
            model_name="offer",
            name="_fts",
            field=models.TextField(blank=True, editable=False),
        ),
        migrations.RunSQL(
            search.fts(
                "offers_offer", ["title", "description", "postal_address", "_fts"]
            )
        ),
        migrations.RunPython(forwards),
    ]
