# Generated by Django 3.1a1 on 2020-06-21 18:50

from decimal import Decimal

import django.contrib.postgres.fields
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("offers", "0009_offer_valid_until"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("projects", "0019_auto_20200523_0929"),
    ]

    operations = [
        migrations.CreateModel(
            name="PlanningTeamMembership",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planning_team_memberships",
                        to="projects.project",
                        verbose_name="project",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planning_team_memberships",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "planning team membership",
                "verbose_name_plural": "planning team memberships",
            },
        ),
        migrations.CreateModel(
            name="PlanningRequest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "requested_hours",
                    models.DecimalField(
                        decimal_places=1,
                        max_digits=10,
                        validators=[
                            django.core.validators.MinValueValidator(Decimal("0.1"))
                        ],
                        verbose_name="requested hours",
                    ),
                ),
                (
                    "planned_hours",
                    models.DecimalField(
                        decimal_places=1,
                        max_digits=10,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="planned hours",
                    ),
                ),
                (
                    "earliest_start_on",
                    models.DateField(verbose_name="earliest start on"),
                ),
                (
                    "completion_requested_on",
                    models.DateField(verbose_name="completion requested on"),
                ),
                ("title", models.CharField(max_length=100, verbose_name="title")),
                (
                    "description",
                    models.TextField(blank=True, verbose_name="description"),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="created at"
                    ),
                ),
                (
                    "closed_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="closed at"
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="sent_planning_requests",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="created by",
                    ),
                ),
                (
                    "offer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="planning_requests",
                        to="offers.offer",
                        verbose_name="offer",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planning_requests",
                        to="projects.project",
                        verbose_name="project",
                    ),
                ),
                (
                    "receivers",
                    models.ManyToManyField(
                        related_name="received_planning_requests",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="receivers",
                    ),
                ),
            ],
            options={
                "verbose_name": "planning request",
                "verbose_name_plural": "planning requests",
                "ordering": ["-pk"],
            },
        ),
        migrations.CreateModel(
            name="PlannedWork",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="created at"
                    ),
                ),
                (
                    "planned_hours",
                    models.DecimalField(
                        decimal_places=1,
                        max_digits=10,
                        validators=[
                            django.core.validators.MinValueValidator(Decimal("0.1"))
                        ],
                        verbose_name="planned hours",
                    ),
                ),
                ("notes", models.TextField(blank=True, verbose_name="notes")),
                (
                    "weeks",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.DateField(), size=None, verbose_name="weeks"
                    ),
                ),
                (
                    "offer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planned_work",
                        to="offers.offer",
                        verbose_name="offer",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planned_work",
                        to="projects.project",
                        verbose_name="project",
                    ),
                ),
                (
                    "request",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="planned_work",
                        to="planning.planningrequest",
                        verbose_name="planning request",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="planned_work",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "planned work",
                "verbose_name_plural": "planned work",
                "ordering": ["-pk"],
            },
        ),
        migrations.RunSQL(
            "SELECT audit_audit_table('planning_planningrequest');"
            "SELECT audit_audit_table('planning_plannedwork');"
        ),
    ]
