---
layout: documentation-api
title: Internationalization
header: Internationalization
group: navigation
tags: field
---
{% include JB/setup %}

Alpaca provides localized bundles for several locales including:

* Chinese (zh_CN)
* Czech (cs_CZ)
* Croatian (hr_HR)
* Dutch (nl_BE)
* Finnish (fi_FI)
* French (fr_FR)
* German (variant 1) (de_AT)
* German (variant 2) (de_DE)
* Greek (el_GR)
* Italian (it_IT)
* Japanese (ja_JP)
* Norwegian (nb_NO)
* Polish (pl_PL)
* Portugeuse (pt_BR)
* Spanish (es_ES)
* Swedish (sv_SE)

These bundles allow Alpaca to render default messages (such as validation messages) in translated languages.

In addition, Alpaca supports localized text in forms.  You simply supply these values as you normally would
within the JSON schema, options or other portions of the Alpaca configuration.

## Example: Spanish

Here is an example of a form that renders in Spanish.  To change the locale to Spanish (<code>es_ES</code>),
override the view and specify the <code>locale</code>.

<div id="field1"> </div>
{% raw %}
<script type="text/javascript" id="field1-script">
$("#field1").alpaca({
    "schema": {
        "title": "Perfil de cliente",
        "description": "Perfil de cliente del helado de la alpaca",
        "type": "object",
        "properties": {
            "name": {
                "title": "Nombre completo",
                "type": "string"
            },
            "age": {
                "title": "Edad",
                "type": "number"
            },
            "icecream": {
                "title": "Helado preferido",
                "type": "string",
                "enum": ["Vanilla", "Chocolate", "Coffee", "Strawberry", "Mint"]
            },
            "address": {
                "title": "Direcci&#243;n de comienzo de la pista en disco",
                "type": "object",
                "properties": {
                    "street": {
                        "title": "Direcci&#243;n de calle",
                        "type": "array",
                        "items": {
                            "type": "string",
                            "maxLength": 30
                        },
                        "minItems": 1,
                        "maxItems": 3                        
                    },
                    "city": {
                        "title": "Ciudad",
                        "type": "string"
                    },
                    "state": {
                        "title": "Estado",
                        "type": "string"
                    },
                    "zip": {
                        "title": "C&#243;digo postal",
                        "type": "string"
                    }
                }
            }
        }
    },
    "options": {
        "fields": {
            "icecream": {
                "optionLabels": [
                    "Vainilla",
                    "Chocolate",
                    "Cafe",
                    "Fresa",
                    "Menta"
                ]
            }
        }
    },
    "view": {
        "locale": "es_ES"
    }
});
</script>
{% endraw %}


## Example: Chinese

Here is an example of a form that renders in Chinese.

<div id="field2"> </div>
{% raw %}
<script type="text/javascript" id="field2-script">
$("#field2").alpaca({
    "schema": {
        "title": "&#29992;&#25143;&#20449;&#24687;",
        "description": "&#38463;&#32819;&#24085;&#20811;&#20892;&#22330;&#20912;&#28608;&#20940;&#24215;&#29992;&#25143;&#20449;&#24687;",
        "type": "object",
        "properties": {
            "name": {
                "title": "&#20840;&#21517;",
                "type": "string"
            },
            "age": {
                "title": "&#24180;&#40836;",
                "type": "number"
            },
            "icecream": {
                "title": "&#26368;&#21916;&#27426;&#30340;&#20912;&#28608;&#20940;",
                "type": "string",
                "enum": ["Vanilla", "Chocolate", "Coffee", "Strawberry", "Mint"]
            },
            "address": {
                "title": "&#23478;&#24237;&#20303;&#22336;",
                "type": "object",
                "properties": {
                    "street": {
                        "title": "&#34903;&#36947;",
                        "type": "array",
                        "items": {
                            "type": "string",
                            "maxLength": 30,
                            "minItems": 1,
                            "maxItems": 3
                        }
                    },
                    "city": {
                        "title": "&#22478;&#24066;",
                        "type": "string"
                    },
                    "state": {
                        "title": "&#24030;&#30465;",
                        "type": "string"
                    },
                    "zip": {
                        "title": "&#37038;&#32534;",
                        "type": "string"
                    }
                }
            }
        }
    },
    "options": {
        "fields": {
            "icecream": {
                "optionLabels": [
                    "&#39321;&#33609;",
                    "&#24039;&#20811;&#21147;",
                    "&#21654;&#21857;",
                    "&#33609;&#33683;",
                    "&#34180;&#33655;"
                ]
            }
        }
    },
    "view": {
        "locale": "zh_CN"
    }
});
</script>
{% endraw %}


## Example: Overriding locale messages on-the-fly

You can override locale-specific messages on the fly.  All values are derived from the underlying messages that you can
 extend programmatically by defining a new view, as shown here.  In this example, we also use the
 <code>$.alpaca.setDefaultLocale()</code> method to set a default language rather than specifying in the options.

<div id="field3"> </div>
{% raw %}
<script type="text/javascript" id="field3-script">
$.alpaca.setDefaultLocale("es_ES");
$("#field3").alpaca({
    "schema": {
        "type": "string",
        "title": "¿Como te llamas?",
        "maxLength": 10
    },
    "data": "Inígo Montoya",
    "view": {
        "messages": {
            "es_ES": {
                "stringValueTooLarge": "Mira, caballero, tu nombre es demasiado largo! (máximo es {0})"
            }
        }
    }
});
</script>
{% endraw %}


## Adding your own locale bundles

Alpaca provides an easy framework for adding and modifying for various languages.  It comes with several i18n bundles
pre-stocked.  All of the i18n bundles are contained within the source code under the
<code>/src/js/messages/i18n</code> directory.

Simply take one of the existing bundles and copy it for your own locale.  Enter all of the translations into it and then
include it into your copy of <code>gulpfile.js</code>.  Then simply specify which <code>locale</code> you'd like Alpaca
to render in within the options.  Or use <code>$.alpaca.setDefaultLocale()</code> to set the default.

And boom, you're all set.

Consider contributing your locale bundle to the Alpaca project!  Chances are that there are others out there trying to
do what you're doing. Your hard work could save someone, somewhere, a lot of time and effort.

Simply submit a pull request with your changes.  Or drop us an email.  We'd enjoy working with you.

