---
layout: page
title: Examples
header: Examples
group: navigation
sitemap:
  priority: 1.0
---
{% include JB/setup %}

Alpaca can be used in all kinds of different ways.  You can use it to render forms for content creation, editing
and read-only display.  You can run it with layouts optimized for Twitter Bootstrap, jQuery UI and jQuery Mobile.
And you can also load it via AMD or right within a browser.


### Getting Started

* <a href="{{ BASE_PATH }}/tutorial.html">Tutorial</a> - a step-by-step guide to building your first Alpaca form on a standalone web page.
* <a href="{{ BASE_PATH }}/demos/alpaca-standalone-sample.html">Standalone Sample</a> - a standalone sample you can use to start your own forms.

### Bootstrap 3

* <a href="{{ BASE_PATH }}/demos/bootstrap/quickstart/index.html">Quick Start Form</a> - loaded using AMD and Require.js
* <a href="{{ BASE_PATH }}/demos/bootstrap/registration/index.html">Registration Form</a> - loaded using AMD and Require.js
* <a href="{{ BASE_PATH }}/demos/bootstrap/bookmarks/bookmarks.html">Bookmarks</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/create-form.html">Customer Profile - Create</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/create-simple-form.html">Customer Profile - Create (Simple)</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/display-form.html">Customer Profile - Display</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/edit-custom-view-form.html">Customer Profile - Edit (Custom View)</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/edit-form.html">Customer Profile - Edit</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/edit-readonly-form.html">Customer Profile - Read Only</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/customer-profile/edit-simple-form.html">Customer Profile - Edit (Simple)</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/login/localized-login.html">Localized Login Form</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/simple/simple1.html">Simple Registration Form #1</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/simple/simple2.html">Simple Registration Form #2</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/multi-column-layouts/index.html">Multi-Column Layouts</a>
* <a href="{{ BASE_PATH }}/demos/bootstrap/clubs/index.html">Clubs (View Selector)</a> - toggle between views and futbol club teams

### jQuery Mobile

* <a href="{{ BASE_PATH }}/demos/jquerymobile/quickstart/index.html">Quick Start Form</a>
* <a href="{{ BASE_PATH }}/demos/jquerymobile/registration/index.html">Registration Form</a>
* <a href="{{ BASE_PATH }}/demos/jquerymobile/customer-profile/customer-profile.html">Customer Profile</a>
* <a href="{{ BASE_PATH }}/demos/jquerymobile/customer-profile/customer-profile-view.html">Customer Profile - View</a>

### jQuery UI

* <a href="{{ BASE_PATH }}/demos/jqueryui/quickstart/index.html">Quick Start Form</a>
* <a href="{{ BASE_PATH }}/demos/jqueryui/registration/index.html">Registration Form</a>

### Web

* <a href="{{ BASE_PATH }}/demos/web/quickstart/index.html">Quick Start Form</a>
* <a href="{{ BASE_PATH }}/demos/web/registration/index.html">Registration Form</a>

### AMD

* <a href="{{ BASE_PATH }}/demos/amd/quickstart/index.html">Quick Start Form</a>
* <a href="{{ BASE_PATH }}/demos/amd/registration/index.html">Registration Form</a>

### Form Builder

* <a href="{{ BASE_PATH }}/demos/form-builder/form-builder.html">Form Builder</a> - a sample form builder that demonstrates visual drag-and-drop assembly
of a form with UI components.

### Videos / Presentations
* <a href="http://www.tribloom.com/index.php/blog/alfraca-alfresco-meets-alpaca" target="_blank">Alfraca - Alfresco with Alpaca Forms</a>
