# -*- coding: utf-8 -*-
# Generated by Django 1.11.5 on 2017-09-29 04:27
from __future__ import unicode_literals

from django.db import migrations


def update_forum_last_topic_and_last_post(apps, schema_editor):
    Forum = apps.get_model('forum', 'Forum')
    Topic = apps.get_model('forum_conversation', 'Topic')
    for forum in Forum.objects.all():
        topics = Topic.objects.filter(forum=forum, approved=True)
        if topics.exists():
            forum.last_post_id = topics[0].last_post_id
            forum.save()


class Migration(migrations.Migration):

    dependencies = [
        ('forum', '0008_forum_last_post'),
    ]

    operations = [
        migrations.RunPython(
            update_forum_last_topic_and_last_post, reverse_code=migrations.RunPython.noop),
    ]
