# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['machina',
 'machina.apps',
 'machina.apps.forum',
 'machina.apps.forum.migrations',
 'machina.apps.forum_conversation',
 'machina.apps.forum_conversation.forum_attachments',
 'machina.apps.forum_conversation.forum_attachments.migrations',
 'machina.apps.forum_conversation.forum_polls',
 'machina.apps.forum_conversation.forum_polls.migrations',
 'machina.apps.forum_conversation.migrations',
 'machina.apps.forum_feeds',
 'machina.apps.forum_member',
 'machina.apps.forum_member.migrations',
 'machina.apps.forum_moderation',
 'machina.apps.forum_permission',
 'machina.apps.forum_permission.migrations',
 'machina.apps.forum_search',
 'machina.apps.forum_tracking',
 'machina.apps.forum_tracking.migrations',
 'machina.conf',
 'machina.core',
 'machina.core.db',
 'machina.forms',
 'machina.models',
 'machina.templatetags',
 'machina.test',
 'machina.test.factories']

package_data = \
{'': ['*'],
 'machina': ['locale/ar/LC_MESSAGES/*',
             'locale/ca/LC_MESSAGES/*',
             'locale/de/LC_MESSAGES/*',
             'locale/en/LC_MESSAGES/*',
             'locale/es/LC_MESSAGES/*',
             'locale/fr/LC_MESSAGES/*',
             'locale/fr_CA/LC_MESSAGES/*',
             'locale/hu/LC_MESSAGES/*',
             'locale/it/LC_MESSAGES/*',
             'locale/ja_JP/LC_MESSAGES/*',
             'locale/nb/LC_MESSAGES/*',
             'locale/nl_NL/LC_MESSAGES/*',
             'locale/pl/LC_MESSAGES/*',
             'locale/pt_BR/LC_MESSAGES/*',
             'locale/ro/LC_MESSAGES/*',
             'locale/ro_RO/LC_MESSAGES/*',
             'locale/ru/LC_MESSAGES/*',
             'locale/sl_SI/LC_MESSAGES/*',
             'locale/zh/LC_MESSAGES/*',
             'locale/zh_CN/LC_MESSAGES/*',
             'locale/zh_TW/LC_MESSAGES/*',
             'static/machina/build/*',
             'static/machina/build/css/*',
             'static/machina/build/css/vendor/*',
             'static/machina/build/fonts/*',
             'static/machina/build/js/*',
             'static/machina/build/js/vendor/*',
             'static/machina/js/*',
             'static/machina/sass/*',
             'static/machina/sass/admin_pages/*',
             'static/machina/sass/board_pages/*',
             'templates/admin/forum/forum/*',
             'templates/machina/*',
             'templates/machina/forum/*',
             'templates/machina/forum_conversation/*',
             'templates/machina/forum_conversation/forum_attachments/*',
             'templates/machina/forum_conversation/forum_polls/*',
             'templates/machina/forum_conversation/partials/*',
             'templates/machina/forum_feeds/*',
             'templates/machina/forum_member/*',
             'templates/machina/forum_moderation/*',
             'templates/machina/forum_moderation/moderation_queue/*',
             'templates/machina/forum_search/*',
             'templates/machina/forum_tracking/*',
             'templates/machina/partials/*']}

install_requires = \
['django-haystack>=2.1',
 'django-mptt>=0.10.0',
 'django-widget-tweaks>=1.4',
 'django>=3.2',
 'markdown2>=2.3',
 'pillow>=2.2']

setup_kwargs = {
    'name': 'django-machina',
    'version': '1.2.0',
    'description': 'A Django forum engine for building powerful community driven websites.',
    'long_description': 'Django-machina\n##############\n\nDjango-machina is a forum framework for Django providing a way to build community-driven websites.\nIt offers a full-featured yet very extensible forum solution:\n\n* Topic and post editing\n* Forums tree management\n* Per-forum permissions\n* Anonymous posting\n* Polls and attachments\n* Moderation and pre-moderation\n* Forum conversations search\n* ...\n\nDjango-machina was built with integration in mind: the application is designed to be used inside\nexisting Django applications. It is not a standalone forum solution.\n\nDjango-machina was built with customization and extensibility in mind: each single functionality\nof the application can be customized or overriden to accommodate with your needs.\n\n.. contents:: Table of Contents\n    :local:\n\nDocumentation\n=============\n\nOnline browsable documentation is available at https://django-machina.readthedocs.org.\n\nHead over to the documentation for all the details on how to set up your forum and how to customize\nit to suit your needs.\n\nRequirements\n============\n\nPython 3.6+, Django 3.2+. Please refer to the requirements_ section of the documentation for a full\nlist of dependencies.\n\n.. _requirements: https://django-machina.readthedocs.org/en/stable/getting_started.html#requirements\n\nAuthors\n=======\n\nMorgan Aubert (`@ellmetha <https://github.com/ellmetha>`_) and contributors_. See ``AUTHORS`` for\nmore details.\n\n.. _contributors: https://github.com/ellmetha/django-machina/contributors\n\nLicense\n=======\n\nBSD. See ``LICENSE`` for more details.\n',
    'author': 'Morgan Aubert',
    'author_email': 'me@morganaubert.name',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ellmetha/django-machina',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
