# PyMammotion - Python API for Mammotion Mowers [![Discord](https://img.shields.io/discord/1247286396297678879)](https://discord.gg/vpZdWhJX8x)

[![SemVer 0.8.5][img_version]][url_version]
[![PyPI Releases][img_pypi]][url_pypi]
[![Supported Python Versions][img_pyversions]][url_pyversions]

[img_version]: https://img.shields.io/static/v1.svg?label=SemVer&message=0.4.0&color=blue
[url_version]: https://pypi.org/project/pymammotion/

[img_pypi]: https://img.shields.io/badge/PyPI-wheels-green.svg
[url_pypi]: https://pypi.org/project/pymammotion/#files

[img_pyversions]: https://img.shields.io/pypi/pyversions/pymammotion.svg
[url_pyversions]: https://pypi.python.org/pypi/pymammotion

💬 [Join us on Discord](https://discord.gg/vpZdWhJX8x)

PyMammotion is a Python API for controlling and monitoring Mammotion robot mowers (Luba, Luba 2 & Yuka) via MQTT, Cloud, and Bluetooth.

⚠️ **Please note:** This API is still under active development. You may encounter unfinished features or bugs. If you come across any issues, please open an issue on the GitHub repository. 🐛

## Home Assistant Integration

This library is the foundation for the [Mammotion Home Assistant integration](https://github.com/mikey0000/Mammotion-HA). If you're looking to control your Mammotion mower through Home Assistant, check out the integration repository for installation and setup instructions.

## Installation 🛠️

You can install PyMammotion using pip:

```bash
pip install pymammotion
```

## Development 🔧

PyMammotion uses `betterproto` and `protoc` for generating protobuf models. To set up the development environment:

1. Clone the repository
2. poetry install --with=dev
3. Profit

## Contributing 🤝

Contributions are welcome! Please check the [issues](https://github.com/mikey0000/pymammotion/issues) for ways you can help improve PyMammotion.

## Troubleshooting 🔍

If you encounter any issues:

- Check the [wiki](https://github.com/mikey0000/pymammotion/wiki) for known issues and solutions
- Ensure you're using the latest version of PyMammotion
- If the problem persists, please open an issue on GitHub

## Credits 👥

[![Contributors](https://contrib.rocks/image?repo=mikey0000/pymammotion)](https://github.com/mikey0000/pymammotion/graphs/contributors)

## License 📄

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.


## Trademark Notice

The trademarks "Mammotion," "Luba," and "Yuka" referenced herein are registered trademarks of their respective owners. The author of this software repository is not affiliated with, endorsed by, or connected to these trademark owners in any way.

