import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html#name DataGoogleComputeHealthCheck#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html#project DataGoogleComputeHealthCheck#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckGrpcHealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get grpcServiceName(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckHttp2HealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    get response(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckHttpHealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    get response(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckHttpsHealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    get response(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckLogConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enable(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckSslHealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    get request(): string;
    /**
     * @stability stable
     */
    get response(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheckTcpHealthCheck extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    get request(): string;
    /**
     * @stability stable
     */
    get response(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html google_compute_health_check}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeHealthCheck extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_health_check.html google_compute_health_check} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeHealthCheckConfig);
    /**
     * @stability stable
     */
    get checkIntervalSec(): number;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    grpcHealthCheck(index: string): DataGoogleComputeHealthCheckGrpcHealthCheck;
    /**
     * @stability stable
     */
    get healthyThreshold(): number;
    /**
     * @stability stable
     */
    http2HealthCheck(index: string): DataGoogleComputeHealthCheckHttp2HealthCheck;
    /**
     * @stability stable
     */
    httpHealthCheck(index: string): DataGoogleComputeHealthCheckHttpHealthCheck;
    /**
     * @stability stable
     */
    httpsHealthCheck(index: string): DataGoogleComputeHealthCheckHttpsHealthCheck;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    logConfig(index: string): DataGoogleComputeHealthCheckLogConfig;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    sslHealthCheck(index: string): DataGoogleComputeHealthCheckSslHealthCheck;
    /**
     * @stability stable
     */
    tcpHealthCheck(index: string): DataGoogleComputeHealthCheckTcpHealthCheck;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get unhealthyThreshold(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
