import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [chatbot](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awschatbot.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Chatbot extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [chatbot](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awschatbot.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Creates an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     */
    createChimeWebhookConfiguration(): this;
    /**
     * Creates an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     */
    createSlackChannelConfiguration(): this;
    /**
     * Deletes an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     */
    deleteChimeWebhookConfiguration(): this;
    /**
     * Deletes an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     */
    deleteSlackChannelConfiguration(): this;
    /**
     * Lists all AWS Chatbot Chime Webhook Configurations in an AWS Account.
     *
     * Access Level: Read
     */
    describeChimeWebhookConfigurations(): this;
    /**
     * Lists all AWS Chatbot Slack Channel Configurations in an AWS account.
     *
     * Access Level: Read
     */
    describeSlackChannelConfigurations(): this;
    /**
     * Lists all public Slack channels in the Slack workspace connected to the AWS Account onboarded with AWS Chatbot service.
     *
     * Access Level: Read
     */
    describeSlackChannels(): this;
    /**
     * Lists all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot service.
     *
     * Access Level: Read
     */
    describeSlackWorkspaces(): this;
    /**
     * Generate OAuth parameters to request Slack OAuth code to be used by the AWS Chatbot service.
     *
     * Access Level: Read
     */
    getSlackOauthParameters(): this;
    /**
     * Redeem previously generated parameters with Slack API, to acquire OAuth tokens to be used by the AWS Chatbot service.
     *
     * Access Level: Write
     */
    redeemSlackOauthCode(): this;
    /**
     * Updates an AWS Chatbot Chime Webhook Configuration.
     *
     * Access Level: Write
     */
    updateChimeWebhookConfiguration(): this;
    /**
     * Updates an AWS Chatbot Slack Channel Configuration.
     *
     * Access Level: Write
     */
    updateSlackChannelConfiguration(): this;
    /**
     * Adds a resource of type ChatbotConfiguration to the statement
     *
     * @param resourceType - Identifier for the resourceType.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onChatbotConfiguration(resourceType: string, resourceName: string, account?: string, partition?: string): this;
}
