"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Importexport = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [importexport](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Importexport extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [importexport](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsimportexportdiskservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'importexport';
        this.actionList = {
            "CancelJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html",
                "description": "This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.",
                "accessLevel": "Write"
            },
            "CreateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html",
                "description": "This action initiates the process of scheduling an upload or download of your data.",
                "accessLevel": "Write"
            },
            "GetShippingLabel": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html",
                "description": "This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.",
                "accessLevel": "Read"
            },
            "GetStatus": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html",
                "description": "This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.",
                "accessLevel": "Read"
            },
            "ListJobs": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html",
                "description": "This action returns the jobs associated with the requester.",
                "accessLevel": "List"
            },
            "UpdateJob": {
                "url": "https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html",
                "description": "You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html
     */
    cancelJob() {
        this.add('importexport:CancelJob');
        return this;
    }
    /**
     * This action initiates the process of scheduling an upload or download of your data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html
     */
    createJob() {
        this.add('importexport:CreateJob');
        return this;
    }
    /**
     * This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html
     */
    getShippingLabel() {
        this.add('importexport:GetShippingLabel');
        return this;
    }
    /**
     * This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html
     */
    getStatus() {
        this.add('importexport:GetStatus');
        return this;
    }
    /**
     * This action returns the jobs associated with the requester.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html
     */
    listJobs() {
        this.add('importexport:ListJobs');
        return this;
    }
    /**
     * You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html
     */
    updateJob() {
        this.add('importexport:UpdateJob');
        return this;
    }
}
exports.Importexport = Importexport;
//# sourceMappingURL=data:application/json;base64,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