"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Launchwizard = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [launchwizard](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_launchwizard.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Launchwizard extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [launchwizard](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_launchwizard.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'launchwizard';
        this.actionList = {
            "DeleteApp": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Delete an application",
                "accessLevel": "Write"
            },
            "DescribeProvisionedApp": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Describe provisioning applications",
                "accessLevel": "Read"
            },
            "DescribeProvisioningEvents": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Describe provisioning events",
                "accessLevel": "Read"
            },
            "GetInfrastructureSuggestion": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get infrastructure suggestion",
                "accessLevel": "Read"
            },
            "GetIpAddress": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get customer's ip address",
                "accessLevel": "Read"
            },
            "GetResourceCostEstimate": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Get resource cost estimate",
                "accessLevel": "Read"
            },
            "ListProvisionedApps": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "List provisioning applications",
                "accessLevel": "List"
            },
            "StartProvisioning": {
                "url": "https://docs.aws.amazon.com/launchwizard/",
                "description": "Start a provisioning",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    deleteApp() {
        this.add('launchwizard:DeleteApp');
        return this;
    }
    /**
     * Describe provisioning applications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    describeProvisionedApp() {
        this.add('launchwizard:DescribeProvisionedApp');
        return this;
    }
    /**
     * Describe provisioning events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    describeProvisioningEvents() {
        this.add('launchwizard:DescribeProvisioningEvents');
        return this;
    }
    /**
     * Get infrastructure suggestion
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getInfrastructureSuggestion() {
        this.add('launchwizard:GetInfrastructureSuggestion');
        return this;
    }
    /**
     * Get customer's ip address
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getIpAddress() {
        this.add('launchwizard:GetIpAddress');
        return this;
    }
    /**
     * Get resource cost estimate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    getResourceCostEstimate() {
        this.add('launchwizard:GetResourceCostEstimate');
        return this;
    }
    /**
     * List provisioning applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    listProvisionedApps() {
        this.add('launchwizard:ListProvisionedApps');
        return this;
    }
    /**
     * Start a provisioning
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/launchwizard/
     */
    startProvisioning() {
        this.add('launchwizard:StartProvisioning');
        return this;
    }
}
exports.Launchwizard = Launchwizard;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGF1bmNod2l6YXJkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGF1bmNod2l6YXJkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHNDQUFvRTtBQUVwRTs7OztHQUlHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsd0JBQWU7SUE4Qy9DOzs7O09BSUc7SUFDSCxZQUFhLEdBQVk7UUFDdkIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBbkROLGtCQUFhLEdBQUcsY0FBYyxDQUFDO1FBQzVCLGVBQVUsR0FBWTtZQUM5QixXQUFXLEVBQUU7Z0JBQ1gsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLHVCQUF1QjtnQkFDdEMsYUFBYSxFQUFFLE9BQU87YUFDdkI7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLG9DQUFvQztnQkFDbkQsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDhCQUE4QjtnQkFDN0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCw2QkFBNkIsRUFBRTtnQkFDN0IsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLCtCQUErQjtnQkFDOUMsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxjQUFjLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDJCQUEyQjtnQkFDMUMsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCx5QkFBeUIsRUFBRTtnQkFDekIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLDRCQUE0QjtnQkFDM0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLGdDQUFnQztnQkFDL0MsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxtQkFBbUIsRUFBRTtnQkFDbkIsS0FBSyxFQUFFLDJDQUEyQztnQkFDbEQsYUFBYSxFQUFFLHNCQUFzQjtnQkFDckMsYUFBYSxFQUFFLE9BQU87YUFDdkI7U0FDRixDQUFDO1FBQ1Esa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBUzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEdBQUcsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBQ25DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsR0FBRyxDQUFDLHFDQUFxQyxDQUFDLENBQUM7UUFDaEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxHQUFHLENBQUMseUNBQXlDLENBQUMsQ0FBQztRQUNwRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEdBQUcsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDO1FBQ3JELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFlBQVk7UUFDakIsSUFBSSxDQUFDLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsR0FBRyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDakQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxHQUFHLENBQUMsa0NBQWtDLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBdEpELG9DQXNKQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjdGlvbnMsIFBvbGljeVN0YXRlbWVudCwgUmVzb3VyY2VUeXBlcyB9IGZyb20gXCIuLi9zaGFyZWRcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2xhdW5jaHdpemFyZF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL2xpc3RfbGF1bmNod2l6YXJkLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgTGF1bmNod2l6YXJkIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnbGF1bmNod2l6YXJkJztcbiAgcHJvdGVjdGVkIGFjdGlvbkxpc3Q6IEFjdGlvbnMgPSB7XG4gICAgXCJEZWxldGVBcHBcIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkRlbGV0ZSBhbiBhcHBsaWNhdGlvblwiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9LFxuICAgIFwiRGVzY3JpYmVQcm92aXNpb25lZEFwcFwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiRGVzY3JpYmUgcHJvdmlzaW9uaW5nIGFwcGxpY2F0aW9uc1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJEZXNjcmliZVByb3Zpc2lvbmluZ0V2ZW50c1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiRGVzY3JpYmUgcHJvdmlzaW9uaW5nIGV2ZW50c1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJHZXRJbmZyYXN0cnVjdHVyZVN1Z2dlc3Rpb25cIjoge1xuICAgICAgXCJ1cmxcIjogXCJodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1wiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkdldCBpbmZyYXN0cnVjdHVyZSBzdWdnZXN0aW9uXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiUmVhZFwiXG4gICAgfSxcbiAgICBcIkdldElwQWRkcmVzc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR2V0IGN1c3RvbWVyJ3MgaXAgYWRkcmVzc1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIlJlYWRcIlxuICAgIH0sXG4gICAgXCJHZXRSZXNvdXJjZUNvc3RFc3RpbWF0ZVwiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiR2V0IHJlc291cmNlIGNvc3QgZXN0aW1hdGVcIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiTGlzdFByb3Zpc2lvbmVkQXBwc1wiOiB7XG4gICAgICBcInVybFwiOiBcImh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXCIsXG4gICAgICBcImRlc2NyaXB0aW9uXCI6IFwiTGlzdCBwcm92aXNpb25pbmcgYXBwbGljYXRpb25zXCIsXG4gICAgICBcImFjY2Vzc0xldmVsXCI6IFwiTGlzdFwiXG4gICAgfSxcbiAgICBcIlN0YXJ0UHJvdmlzaW9uaW5nXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cIixcbiAgICAgIFwiZGVzY3JpcHRpb25cIjogXCJTdGFydCBhIHByb3Zpc2lvbmluZ1wiLFxuICAgICAgXCJhY2Nlc3NMZXZlbFwiOiBcIldyaXRlXCJcbiAgICB9XG4gIH07XG4gIHByb3RlY3RlZCByZXNvdXJjZVR5cGVzOiBSZXNvdXJjZVR5cGVzID0ge307XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbGF1bmNod2l6YXJkXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9sYXVuY2h3aXphcmQuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3IgKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlIGFuIGFwcGxpY2F0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cbiAgICovXG4gIHB1YmxpYyBkZWxldGVBcHAoKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpEZWxldGVBcHAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXNjcmliZSBwcm92aXNpb25pbmcgYXBwbGljYXRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGRlc2NyaWJlUHJvdmlzaW9uZWRBcHAoKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpEZXNjcmliZVByb3Zpc2lvbmVkQXBwJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVzY3JpYmUgcHJvdmlzaW9uaW5nIGV2ZW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cbiAgICovXG4gIHB1YmxpYyBkZXNjcmliZVByb3Zpc2lvbmluZ0V2ZW50cygpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkRlc2NyaWJlUHJvdmlzaW9uaW5nRXZlbnRzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0IGluZnJhc3RydWN0dXJlIHN1Z2dlc3Rpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sYXVuY2h3aXphcmQvXG4gICAqL1xuICBwdWJsaWMgZ2V0SW5mcmFzdHJ1Y3R1cmVTdWdnZXN0aW9uKCkge1xuICAgIHRoaXMuYWRkKCdsYXVuY2h3aXphcmQ6R2V0SW5mcmFzdHJ1Y3R1cmVTdWdnZXN0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0IGN1c3RvbWVyJ3MgaXAgYWRkcmVzc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cbiAgICovXG4gIHB1YmxpYyBnZXRJcEFkZHJlc3MoKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpHZXRJcEFkZHJlc3MnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgcmVzb3VyY2UgY29zdCBlc3RpbWF0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhdW5jaHdpemFyZC9cbiAgICovXG4gIHB1YmxpYyBnZXRSZXNvdXJjZUNvc3RFc3RpbWF0ZSgpIHtcbiAgICB0aGlzLmFkZCgnbGF1bmNod2l6YXJkOkdldFJlc291cmNlQ29zdEVzdGltYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCBwcm92aXNpb25pbmcgYXBwbGljYXRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIGxpc3RQcm92aXNpb25lZEFwcHMoKSB7XG4gICAgdGhpcy5hZGQoJ2xhdW5jaHdpemFyZDpMaXN0UHJvdmlzaW9uZWRBcHBzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU3RhcnQgYSBwcm92aXNpb25pbmdcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbGF1bmNod2l6YXJkL1xuICAgKi9cbiAgcHVibGljIHN0YXJ0UHJvdmlzaW9uaW5nKCkge1xuICAgIHRoaXMuYWRkKCdsYXVuY2h3aXphcmQ6U3RhcnRQcm92aXNpb25pbmcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19