"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLevel = void 0;
/**
 * Access level classifications for the actions in a service
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_understand-policy-summary-access-level-summaries.html#access_policies_access-level
 */
var AccessLevel;
(function (AccessLevel) {
    /**
     * Permission to list resources within the service to determine whether an object exists.
     *
     * Actions with this level of access can list objects but cannot see the contents of a resource.
     *
     * For example, the Amazon S3 action `ListBucket` has the List access level.
     */
    AccessLevel["LIST"] = "List";
    /**
     * Permission to read but not edit the contents and attributes of resources in the service.
     *
     * For example, the Amazon S3 actions `GetObject` and `GetBucketLocation` have the Read access level.
     */
    AccessLevel["READ"] = "Read";
    /**
     * Permission to create, delete, or modify resources in the service.
     *
     * For example, the Amazon S3 actions `CreateBucket`, `DeleteBucket` and `PutObject` have the Write access level.
     *
     * Write actions might also allow modifying a resource tag. However, an action that allows only changes to tags has the Tagging access level.
     */
    AccessLevel["WRITE"] = "Write";
    /**
     * Permission to grant or modify resource permissions in the service.
     *
     * For example, most IAM and AWS Organizations actions, as well as actions like the Amazon S3 actions `PutBucketPolicy` and `DeleteBucketPolicy` have the Permissions management access level.
     */
    AccessLevel["PERMISSION_MANAGEMENT"] = "Permissions management";
    /**
     * Permission to perform actions that only change the state of resource tags.
     *
     * For example, the IAM actions `TagRole` and `UntagRole` have the Tagging access level because they allow only tagging or untagging a role. However, the `CreateRole` action allows tagging a role resource when you create that role. Because the action does not only add a tag, it has the Write access level.
     */
    AccessLevel["TAGGING"] = "Tagging";
})(AccessLevel = exports.AccessLevel || (exports.AccessLevel = {}));
//# sourceMappingURL=data:application/json;base64,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