import * as ec2 from '@aws-cdk/aws-ec2';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import { App, Construct, Stack } from '@aws-cdk/core';
export declare function testFixture(): {
    stack: Stack;
    vpc: ec2.Vpc;
    app: App;
};
export declare function testFixtureNoVpc(): {
    stack: Stack;
    app: App;
};
export declare function testFixtureAlb(): {
    stack: Stack;
    app: App;
    alb: elbv2.ApplicationLoadBalancer;
};
export declare function testFixtureNlb(): {
    stack: Stack;
    app: App;
    nlb: elbv2.NetworkLoadBalancer;
};
export declare function testFixtureEip(): {
    stack: Stack;
    app: App;
    eip: ec2.CfnEIP;
};
export declare function testFixtureEc2(): {
    stack: Stack;
    app: App;
    instance: ec2.Instance;
};
export declare class TestStack extends Stack {
    constructor(scope: Construct, id: string);
}
