"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestStack = exports.testFixtureEc2 = exports.testFixtureEip = exports.testFixtureNlb = exports.testFixtureAlb = exports.testFixtureNoVpc = exports.testFixture = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
function testFixture() {
    const { stack, app } = testFixtureNoVpc();
    const vpc = new ec2.Vpc(stack, 'VPC');
    return { stack, vpc, app };
}
exports.testFixture = testFixture;
function testFixtureNoVpc() {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Stack');
    return { stack, app };
}
exports.testFixtureNoVpc = testFixtureNoVpc;
function testFixtureAlb() {
    const { stack, app, vpc } = testFixture();
    const alb = new elbv2.ApplicationLoadBalancer(stack, 'ALB', { vpc, internetFacing: true });
    return { stack, app, alb };
}
exports.testFixtureAlb = testFixtureAlb;
function testFixtureNlb() {
    const { stack, app, vpc } = testFixture();
    const nlb = new elbv2.NetworkLoadBalancer(stack, 'NLB', { vpc, internetFacing: true });
    return { stack, app, nlb };
}
exports.testFixtureNlb = testFixtureNlb;
function testFixtureEip() {
    const { stack, app } = testFixtureNoVpc();
    const eip = new ec2.CfnEIP(stack, 'ElasticIpAddress');
    return { stack, app, eip };
}
exports.testFixtureEip = testFixtureEip;
function testFixtureEc2() {
    const { stack, app, vpc } = testFixture();
    const instance = new ec2.Instance(stack, 'Ec2', {
        vpc,
        machineImage: new ec2.AmazonLinuxImage(),
        instanceType: new ec2.InstanceType('t3.small'),
    });
    return { stack, app, instance };
}
exports.testFixtureEc2 = testFixtureEc2;
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
    }
}
exports.TestStack = TestStack;
//# sourceMappingURL=data:application/json;base64,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