from .bluequbit_device import BluequbitDevice


class BluequbitCPU(BluequbitDevice):
    """BluequbitCPU device for PennyLane. This device is used to run Pennylane circuits on BlueQubit platform using a
    cpu device and is similar to using lightning.qubit on your local device. It requires a BlueQubit token, which
    you can get from your BlueQubit account.

    .. warning::

            To use this plugin, you must have pennylane>=0.39 version installed. It requires
            Python 3.9, but we would recommend using Python 3.10 . Make sure your Python version
            is not older.

    Args:
        wires (int, Iterable[Number, str]): Number of subsystems represented by the device,
            or iterable that contains unique labels for the subsystems as numbers (i.e., ``[-1, 0, 2]``)
            or strings (``['auxiliary', 'q1', 'q2']``). Default 1 if not specified.
        token (str, None): Your BlueQubit token. This is a required keyword-only argument, so you have to specify
            it every time, even when you give your token through the environment variable. If you have set your token
            in BLUEQUBIT_API_TOKEN environment variable you should pass token=None to the device.
    """

    short_name = "bluequbit.cpu"

    def __init__(self, wires, *args, token, **kwargs):
        super().__init__(wires, *args, token=token, **kwargs)
        self._device = "pennylane.cpu"
