import { Duration } from '@aws-cdk/core';
/**
 * (experimental) Schedule for canary runs.
 *
 * @experimental
 */
export declare class Schedule {
    /**
     * The Schedule expression
     */
    readonly expressionString: string;
    /**
     * (experimental) The canary will be executed once.
     *
     * @experimental
     */
    static once(): Schedule;
    /**
     * (experimental) Construct a schedule from a literal schedule expression.
     *
     * The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     * @experimental
     */
    static expression(expression: string): Schedule;
    /**
     * (experimental) Construct a schedule from an interval.
     *
     * Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary.
     * @experimental
     */
    static rate(interval: Duration): Schedule;
    /**
     * (experimental) Create a schedule from a set of cron fields.
     *
     * @experimental
     */
    static cron(options: CronOptions): Schedule;
    private constructor();
}
/**
 * (experimental) Options to configure a cron expression.
 *
 * All fields are strings so you can use complex expressions. Absence of
 * a field implies '*' or '?', whichever one is appropriate.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html
 * @experimental
 */
export interface CronOptions {
    /**
     * (experimental) The minute to run this rule at.
     *
     * @default - Every minute
     * @experimental
     */
    readonly minute?: string;
    /**
     * (experimental) The hour to run this rule at.
     *
     * @default - Every hour
     * @experimental
     */
    readonly hour?: string;
    /**
     * (experimental) The day of the month to run this rule at.
     *
     * @default - Every day of the month
     * @experimental
     */
    readonly day?: string;
    /**
     * (experimental) The month to run this rule at.
     *
     * @default - Every month
     * @experimental
     */
    readonly month?: string;
    /**
     * (experimental) The day of the week to run this rule at.
     *
     * @default - Any day of the week
     * @experimental
     */
    readonly weekDay?: string;
}
