# Generated by Django 4.1 on 2022-10-25 20:35

from django.db import migrations


def add_language(apps, schema_editor):
    Book = apps.get_model("book", "Book")
    for book in Book.objects.all():
        book.settings["language"] = "en-US"
        book.save()


def remove_language(apps, schema_editor):
    Book = apps.get_model("book", "Book")
    for book in Book.objects.all():
        book.settings.pop("language", None)
        book.save()


class Migration(migrations.Migration):

    dependencies = [
        ("book", "0013_move_json_data"),
    ]

    operations = [
        migrations.RunPython(
            add_language,
            remove_language,
        ),
    ]
