import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclBindingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the ACL auth method this rule apply.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#auth_method AclBindingRule#auth_method}
    */
    readonly authMethod: string;
    /**
    * The name to bind to a token at login-time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#bind_name AclBindingRule#bind_name}
    */
    readonly bindName: string;
    /**
    * Specifies the way the binding rule affects a token created at login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#bind_type AclBindingRule#bind_type}
    */
    readonly bindType: string;
    /**
    * A free form human readable description of the binding rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#description AclBindingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#id AclBindingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#namespace AclBindingRule#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the ACL binding rule is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#partition AclBindingRule#partition}
    */
    readonly partition?: string;
    /**
    * The expression used to math this rule against valid identities returned from an auth method validation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule#selector AclBindingRule#selector}
    */
    readonly selector?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule consul_acl_binding_rule}
*/
export declare class AclBindingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_binding_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_binding_rule consul_acl_binding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclBindingRuleConfig
    */
    constructor(scope: Construct, id: string, config: AclBindingRuleConfig);
    private _authMethod?;
    get authMethod(): string;
    set authMethod(value: string);
    get authMethodInput(): string | undefined;
    private _bindName?;
    get bindName(): string;
    set bindName(value: string);
    get bindNameInput(): string | undefined;
    private _bindType?;
    get bindType(): string;
    set bindType(value: string);
    get bindTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
