import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclTokenPolicyAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_policy_attachment#id AclTokenPolicyAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The policy name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_policy_attachment#policy AclTokenPolicyAttachment#policy}
    */
    readonly policy: string;
    /**
    * The token accessor id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_policy_attachment#token_id AclTokenPolicyAttachment#token_id}
    */
    readonly tokenId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_token_policy_attachment consul_acl_token_policy_attachment}
*/
export declare class AclTokenPolicyAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_token_policy_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_token_policy_attachment consul_acl_token_policy_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclTokenPolicyAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: AclTokenPolicyAttachmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    private _tokenId?;
    get tokenId(): string;
    set tokenId(value: string);
    get tokenIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
