import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The token id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#accessor_id AclToken#accessor_id}
    */
    readonly accessorId?: string;
    /**
    * The token description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#description AclToken#description}
    */
    readonly description?: string;
    /**
    * If set this represents the point after which a token should be considered revoked and is eligible for destruction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#expiration_time AclToken#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#id AclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Flag to set the token local to the current datacenter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#local AclToken#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#namespace AclToken#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the ACL token is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#partition AclToken#partition}
    */
    readonly partition?: string;
    /**
    * List of policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#policies AclToken#policies}
    */
    readonly policies?: string[];
    /**
    * List of roles
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#roles AclToken#roles}
    */
    readonly roles?: string[];
    /**
    * node_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#node_identities AclToken#node_identities}
    */
    readonly nodeIdentities?: AclTokenNodeIdentities[] | cdktf.IResolvable;
    /**
    * service_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#service_identities AclToken#service_identities}
    */
    readonly serviceIdentities?: AclTokenServiceIdentities[] | cdktf.IResolvable;
}
export interface AclTokenNodeIdentities {
    /**
    * Specifies the node's datacenter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#datacenter AclToken#datacenter}
    */
    readonly datacenter: string;
    /**
    * The name of the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#node_name AclToken#node_name}
    */
    readonly nodeName: string;
}
export declare function aclTokenNodeIdentitiesToTerraform(struct?: AclTokenNodeIdentities | cdktf.IResolvable): any;
export declare class AclTokenNodeIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclTokenNodeIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: AclTokenNodeIdentities | cdktf.IResolvable | undefined);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    get datacenterInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    get nodeNameInput(): string | undefined;
}
export declare class AclTokenNodeIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclTokenNodeIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclTokenNodeIdentitiesOutputReference;
}
export interface AclTokenServiceIdentities {
    /**
    * Specifies the datacenters the effective policy is valid within.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#datacenters AclToken#datacenters}
    */
    readonly datacenters?: string[];
    /**
    * The name of the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token#service_name AclToken#service_name}
    */
    readonly serviceName: string;
}
export declare function aclTokenServiceIdentitiesToTerraform(struct?: AclTokenServiceIdentities | cdktf.IResolvable): any;
export declare class AclTokenServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclTokenServiceIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: AclTokenServiceIdentities | cdktf.IResolvable | undefined);
    private _datacenters?;
    get datacenters(): string[];
    set datacenters(value: string[]);
    resetDatacenters(): void;
    get datacentersInput(): string[] | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
}
export declare class AclTokenServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclTokenServiceIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclTokenServiceIdentitiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_token consul_acl_token}
*/
export declare class AclToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_token consul_acl_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclTokenConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AclTokenConfig);
    private _accessorId?;
    get accessorId(): string;
    set accessorId(value: string);
    resetAccessorId(): void;
    get accessorIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _nodeIdentities;
    get nodeIdentities(): AclTokenNodeIdentitiesList;
    putNodeIdentities(value: AclTokenNodeIdentities[] | cdktf.IResolvable): void;
    resetNodeIdentities(): void;
    get nodeIdentitiesInput(): cdktf.IResolvable | AclTokenNodeIdentities[] | undefined;
    private _serviceIdentities;
    get serviceIdentities(): AclTokenServiceIdentitiesList;
    putServiceIdentities(value: AclTokenServiceIdentities[] | cdktf.IResolvable): void;
    resetServiceIdentities(): void;
    get serviceIdentitiesInput(): cdktf.IResolvable | AclTokenServiceIdentities[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
