import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutopilotConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#cleanup_dead_servers AutopilotConfig#cleanup_dead_servers}
    */
    readonly cleanupDeadServers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#datacenter AutopilotConfig#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#disable_upgrade_migration AutopilotConfig#disable_upgrade_migration}
    */
    readonly disableUpgradeMigration?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#id AutopilotConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#last_contact_threshold AutopilotConfig#last_contact_threshold}
    */
    readonly lastContactThreshold?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#max_trailing_logs AutopilotConfig#max_trailing_logs}
    */
    readonly maxTrailingLogs?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#redundancy_zone_tag AutopilotConfig#redundancy_zone_tag}
    */
    readonly redundancyZoneTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#server_stabilization_time AutopilotConfig#server_stabilization_time}
    */
    readonly serverStabilizationTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config#upgrade_version_tag AutopilotConfig#upgrade_version_tag}
    */
    readonly upgradeVersionTag?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config consul_autopilot_config}
*/
export declare class AutopilotConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_autopilot_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config consul_autopilot_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutopilotConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AutopilotConfigConfig);
    private _cleanupDeadServers?;
    get cleanupDeadServers(): boolean | cdktf.IResolvable;
    set cleanupDeadServers(value: boolean | cdktf.IResolvable);
    resetCleanupDeadServers(): void;
    get cleanupDeadServersInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _disableUpgradeMigration?;
    get disableUpgradeMigration(): boolean | cdktf.IResolvable;
    set disableUpgradeMigration(value: boolean | cdktf.IResolvable);
    resetDisableUpgradeMigration(): void;
    get disableUpgradeMigrationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastContactThreshold?;
    get lastContactThreshold(): string;
    set lastContactThreshold(value: string);
    resetLastContactThreshold(): void;
    get lastContactThresholdInput(): string | undefined;
    private _maxTrailingLogs?;
    get maxTrailingLogs(): number;
    set maxTrailingLogs(value: number);
    resetMaxTrailingLogs(): void;
    get maxTrailingLogsInput(): number | undefined;
    private _redundancyZoneTag?;
    get redundancyZoneTag(): string;
    set redundancyZoneTag(value: string);
    resetRedundancyZoneTag(): void;
    get redundancyZoneTagInput(): string | undefined;
    private _serverStabilizationTime?;
    get serverStabilizationTime(): string;
    set serverStabilizationTime(value: string);
    resetServerStabilizationTime(): void;
    get serverStabilizationTimeInput(): string | undefined;
    private _upgradeVersionTag?;
    get upgradeVersionTag(): string;
    set upgradeVersionTag(value: string);
    resetUpgradeVersionTag(): void;
    get upgradeVersionTagInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
