"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutopilotConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config consul_autopilot_config}
*/
class AutopilotConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/autopilot_config consul_autopilot_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutopilotConfigConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'consul_autopilot_config',
            terraformGeneratorMetadata: {
                providerName: 'consul',
                providerVersion: '2.16.2',
                providerVersionConstraint: '~> 2.16'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._cleanupDeadServers = config.cleanupDeadServers;
        this._datacenter = config.datacenter;
        this._disableUpgradeMigration = config.disableUpgradeMigration;
        this._id = config.id;
        this._lastContactThreshold = config.lastContactThreshold;
        this._maxTrailingLogs = config.maxTrailingLogs;
        this._redundancyZoneTag = config.redundancyZoneTag;
        this._serverStabilizationTime = config.serverStabilizationTime;
        this._upgradeVersionTag = config.upgradeVersionTag;
    }
    get cleanupDeadServers() {
        return this.getBooleanAttribute('cleanup_dead_servers');
    }
    set cleanupDeadServers(value) {
        this._cleanupDeadServers = value;
    }
    resetCleanupDeadServers() {
        this._cleanupDeadServers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cleanupDeadServersInput() {
        return this._cleanupDeadServers;
    }
    get datacenter() {
        return this.getStringAttribute('datacenter');
    }
    set datacenter(value) {
        this._datacenter = value;
    }
    resetDatacenter() {
        this._datacenter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datacenterInput() {
        return this._datacenter;
    }
    get disableUpgradeMigration() {
        return this.getBooleanAttribute('disable_upgrade_migration');
    }
    set disableUpgradeMigration(value) {
        this._disableUpgradeMigration = value;
    }
    resetDisableUpgradeMigration() {
        this._disableUpgradeMigration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableUpgradeMigrationInput() {
        return this._disableUpgradeMigration;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lastContactThreshold() {
        return this.getStringAttribute('last_contact_threshold');
    }
    set lastContactThreshold(value) {
        this._lastContactThreshold = value;
    }
    resetLastContactThreshold() {
        this._lastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastContactThresholdInput() {
        return this._lastContactThreshold;
    }
    get maxTrailingLogs() {
        return this.getNumberAttribute('max_trailing_logs');
    }
    set maxTrailingLogs(value) {
        this._maxTrailingLogs = value;
    }
    resetMaxTrailingLogs() {
        this._maxTrailingLogs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTrailingLogsInput() {
        return this._maxTrailingLogs;
    }
    get redundancyZoneTag() {
        return this.getStringAttribute('redundancy_zone_tag');
    }
    set redundancyZoneTag(value) {
        this._redundancyZoneTag = value;
    }
    resetRedundancyZoneTag() {
        this._redundancyZoneTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redundancyZoneTagInput() {
        return this._redundancyZoneTag;
    }
    get serverStabilizationTime() {
        return this.getStringAttribute('server_stabilization_time');
    }
    set serverStabilizationTime(value) {
        this._serverStabilizationTime = value;
    }
    resetServerStabilizationTime() {
        this._serverStabilizationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverStabilizationTimeInput() {
        return this._serverStabilizationTime;
    }
    get upgradeVersionTag() {
        return this.getStringAttribute('upgrade_version_tag');
    }
    set upgradeVersionTag(value) {
        this._upgradeVersionTag = value;
    }
    resetUpgradeVersionTag() {
        this._upgradeVersionTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upgradeVersionTagInput() {
        return this._upgradeVersionTag;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cleanup_dead_servers: cdktf.booleanToTerraform(this._cleanupDeadServers),
            datacenter: cdktf.stringToTerraform(this._datacenter),
            disable_upgrade_migration: cdktf.booleanToTerraform(this._disableUpgradeMigration),
            id: cdktf.stringToTerraform(this._id),
            last_contact_threshold: cdktf.stringToTerraform(this._lastContactThreshold),
            max_trailing_logs: cdktf.numberToTerraform(this._maxTrailingLogs),
            redundancy_zone_tag: cdktf.stringToTerraform(this._redundancyZoneTag),
            server_stabilization_time: cdktf.stringToTerraform(this._serverStabilizationTime),
            upgrade_version_tag: cdktf.stringToTerraform(this._upgradeVersionTag),
        };
    }
}
exports.AutopilotConfig = AutopilotConfig;
_a = JSII_RTTI_SYMBOL_1;
AutopilotConfig[_a] = { fqn: "@cdktf/provider-consul.autopilotConfig.AutopilotConfig", version: "1.0.1" };
// =================
// STATIC PROPERTIES
// =================
AutopilotConfig.tfResourceType = "consul_autopilot_config";
//# sourceMappingURL=data:application/json;base64,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