import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigEntryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#config_json ConfigEntry#config_json}
    */
    readonly configJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#id ConfigEntry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#kind ConfigEntry#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#name ConfigEntry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#namespace ConfigEntry#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the config entry is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/config_entry#partition ConfigEntry#partition}
    */
    readonly partition?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/config_entry consul_config_entry}
*/
export declare class ConfigEntry extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_config_entry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/config_entry consul_config_entry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigEntryConfig
    */
    constructor(scope: Construct, id: string, config: ConfigEntryConfig);
    private _configJson?;
    get configJson(): string;
    set configJson(value: string);
    resetConfigJson(): void;
    get configJsonInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
