import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAclRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_role#id DataConsulAclRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_role#name DataConsulAclRole#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_role#namespace DataConsulAclRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_role#partition DataConsulAclRole#partition}
    */
    readonly partition?: string;
}
export interface DataConsulAclRoleNodeIdentities {
}
export declare function dataConsulAclRoleNodeIdentitiesToTerraform(struct?: DataConsulAclRoleNodeIdentities): any;
export declare class DataConsulAclRoleNodeIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclRoleNodeIdentities | undefined;
    set internalValue(value: DataConsulAclRoleNodeIdentities | undefined);
    get datacenter(): string;
    get nodeName(): string;
}
export declare class DataConsulAclRoleNodeIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclRoleNodeIdentitiesOutputReference;
}
export interface DataConsulAclRolePolicies {
}
export declare function dataConsulAclRolePoliciesToTerraform(struct?: DataConsulAclRolePolicies): any;
export declare class DataConsulAclRolePoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclRolePolicies | undefined;
    set internalValue(value: DataConsulAclRolePolicies | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataConsulAclRolePoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclRolePoliciesOutputReference;
}
export interface DataConsulAclRoleServiceIdentities {
}
export declare function dataConsulAclRoleServiceIdentitiesToTerraform(struct?: DataConsulAclRoleServiceIdentities): any;
export declare class DataConsulAclRoleServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclRoleServiceIdentities | undefined;
    set internalValue(value: DataConsulAclRoleServiceIdentities | undefined);
    get datacenters(): string[];
    get serviceName(): string;
}
export declare class DataConsulAclRoleServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclRoleServiceIdentitiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/acl_role consul_acl_role}
*/
export declare class DataConsulAclRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_acl_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/acl_role consul_acl_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAclRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulAclRoleConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _nodeIdentities;
    get nodeIdentities(): DataConsulAclRoleNodeIdentitiesList;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policies;
    get policies(): DataConsulAclRolePoliciesList;
    private _serviceIdentities;
    get serviceIdentities(): DataConsulAclRoleServiceIdentitiesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
