import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAclTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_token#accessor_id DataConsulAclToken#accessor_id}
    */
    readonly accessorId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_token#id DataConsulAclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_token#namespace DataConsulAclToken#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_token#partition DataConsulAclToken#partition}
    */
    readonly partition?: string;
}
export interface DataConsulAclTokenNodeIdentities {
}
export declare function dataConsulAclTokenNodeIdentitiesToTerraform(struct?: DataConsulAclTokenNodeIdentities): any;
export declare class DataConsulAclTokenNodeIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclTokenNodeIdentities | undefined;
    set internalValue(value: DataConsulAclTokenNodeIdentities | undefined);
    get datacenter(): string;
    get nodeName(): string;
}
export declare class DataConsulAclTokenNodeIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclTokenNodeIdentitiesOutputReference;
}
export interface DataConsulAclTokenPolicies {
}
export declare function dataConsulAclTokenPoliciesToTerraform(struct?: DataConsulAclTokenPolicies): any;
export declare class DataConsulAclTokenPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclTokenPolicies | undefined;
    set internalValue(value: DataConsulAclTokenPolicies | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataConsulAclTokenPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclTokenPoliciesOutputReference;
}
export interface DataConsulAclTokenRoles {
}
export declare function dataConsulAclTokenRolesToTerraform(struct?: DataConsulAclTokenRoles): any;
export declare class DataConsulAclTokenRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclTokenRoles | undefined;
    set internalValue(value: DataConsulAclTokenRoles | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataConsulAclTokenRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclTokenRolesOutputReference;
}
export interface DataConsulAclTokenServiceIdentities {
}
export declare function dataConsulAclTokenServiceIdentitiesToTerraform(struct?: DataConsulAclTokenServiceIdentities): any;
export declare class DataConsulAclTokenServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclTokenServiceIdentities | undefined;
    set internalValue(value: DataConsulAclTokenServiceIdentities | undefined);
    get datacenters(): string[];
    get serviceName(): string;
}
export declare class DataConsulAclTokenServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclTokenServiceIdentitiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/acl_token consul_acl_token}
*/
export declare class DataConsulAclToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_acl_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/acl_token consul_acl_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAclTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulAclTokenConfig);
    private _accessorId?;
    get accessorId(): string;
    set accessorId(value: string);
    get accessorIdInput(): string | undefined;
    get description(): string;
    get expirationTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get local(): cdktf.IResolvable;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _nodeIdentities;
    get nodeIdentities(): DataConsulAclTokenNodeIdentitiesList;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policies;
    get policies(): DataConsulAclTokenPoliciesList;
    private _roles;
    get roles(): DataConsulAclTokenRolesList;
    private _serviceIdentities;
    get serviceIdentities(): DataConsulAclTokenServiceIdentitiesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
