import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAgentSelfConfig extends cdktf.TerraformMetaArguments {
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/agent_self consul_agent_self}
*/
export declare class DataConsulAgentSelf extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_agent_self";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/agent_self consul_agent_self} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAgentSelfConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataConsulAgentSelfConfig);
    get aclDatacenter(): string;
    get aclDefaultPolicy(): string;
    get aclDisabledTtl(): string;
    get aclDownPolicy(): string;
    get aclEnforce08Semantics(): cdktf.IResolvable;
    get aclTtl(): string;
    private _addresses;
    get addresses(): cdktf.StringMap;
    get advertiseAddr(): string;
    get advertiseAddrWan(): string;
    private _advertiseAddrs;
    get advertiseAddrs(): cdktf.StringMap;
    get atlasJoin(): cdktf.IResolvable;
    get bindAddr(): string;
    get bootstrapExpect(): number;
    get bootstrapMode(): cdktf.IResolvable;
    get checkDeregisterIntervalMin(): string;
    get checkReapInterval(): string;
    get checkUpdateInterval(): string;
    get clientAddr(): string;
    get dataDir(): string;
    get datacenter(): string;
    get devMode(): cdktf.IResolvable;
    private _dns;
    get dns(): cdktf.StringMap;
    get dnsRecursors(): string[];
    get domain(): string;
    get enableAnonymousSignature(): cdktf.IResolvable;
    get enableCoordinates(): cdktf.IResolvable;
    get enableDebug(): cdktf.IResolvable;
    get enableRemoteExec(): cdktf.IResolvable;
    get enableSyslog(): cdktf.IResolvable;
    get enableUi(): cdktf.IResolvable;
    get enableUpdateCheck(): cdktf.IResolvable;
    get id(): string;
    get leaveOnInt(): cdktf.IResolvable;
    get leaveOnTerm(): cdktf.IResolvable;
    get logLevel(): string;
    get name(): string;
    private _performance;
    get performance(): cdktf.StringMap;
    get pidFile(): string;
    private _ports;
    get ports(): cdktf.NumberMap;
    get protocolVersion(): number;
    get reconnectTimeoutLan(): string;
    get reconnectTimeoutWan(): string;
    get rejoinAfterLeave(): cdktf.IResolvable;
    get retryJoin(): string[];
    private _retryJoinEc2;
    get retryJoinEc2(): cdktf.StringMap;
    private _retryJoinGce;
    get retryJoinGce(): cdktf.StringMap;
    get retryJoinWan(): string[];
    get retryMaxAttempts(): number;
    get retryMaxAttemptsWan(): number;
    get serfLanBindAddr(): string;
    get serfWanBindAddr(): string;
    get serverMode(): cdktf.IResolvable;
    get serverName(): string;
    get sessionTtlMin(): string;
    get startJoin(): string[];
    get startJoinWan(): string[];
    get syslogFacility(): string;
    private _taggedAddresses;
    get taggedAddresses(): cdktf.StringMap;
    private _telemetry;
    get telemetry(): cdktf.StringMap;
    get tlsCaFile(): string;
    get tlsCertFile(): string;
    get tlsKeyFile(): string;
    get tlsMinVersion(): string;
    get tlsVerifyIncoming(): cdktf.IResolvable;
    get tlsVerifyOutgoing(): cdktf.IResolvable;
    get tlsVerifyServerHostname(): cdktf.IResolvable;
    get translateWanAddrs(): cdktf.IResolvable;
    get uiDir(): string;
    private _unixSockets;
    get unixSockets(): cdktf.StringMap;
    get version(): string;
    get versionPrerelease(): string;
    get versionRevision(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
