import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulCatalogServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#datacenter DataConsulCatalogService#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#filter DataConsulCatalogService#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#id DataConsulCatalogService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#name DataConsulCatalogService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#tag DataConsulCatalogService#tag}
    */
    readonly tag?: string;
    /**
    * query_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#query_options DataConsulCatalogService#query_options}
    */
    readonly queryOptions?: DataConsulCatalogServiceQueryOptions[] | cdktf.IResolvable;
}
export interface DataConsulCatalogServiceService {
}
export declare function dataConsulCatalogServiceServiceToTerraform(struct?: DataConsulCatalogServiceService): any;
export declare class DataConsulCatalogServiceServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulCatalogServiceService | undefined;
    set internalValue(value: DataConsulCatalogServiceService | undefined);
    get address(): string;
    get createIndex(): string;
    get enableTagOverride(): string;
    get id(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get modifyIndex(): string;
    get name(): string;
    get nodeAddress(): string;
    get nodeId(): string;
    private _nodeMeta;
    get nodeMeta(): cdktf.StringMap;
    get nodeName(): string;
    get port(): string;
    private _taggedAddresses;
    get taggedAddresses(): cdktf.StringMap;
    get tags(): string[];
}
export declare class DataConsulCatalogServiceServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulCatalogServiceServiceOutputReference;
}
export interface DataConsulCatalogServiceQueryOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#allow_stale DataConsulCatalogService#allow_stale}
    */
    readonly allowStale?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#datacenter DataConsulCatalogService#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#namespace DataConsulCatalogService#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#near DataConsulCatalogService#near}
    */
    readonly near?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#node_meta DataConsulCatalogService#node_meta}
    */
    readonly nodeMeta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#partition DataConsulCatalogService#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#require_consistent DataConsulCatalogService#require_consistent}
    */
    readonly requireConsistent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#token DataConsulCatalogService#token}
    */
    readonly token?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#wait_index DataConsulCatalogService#wait_index}
    */
    readonly waitIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_service#wait_time DataConsulCatalogService#wait_time}
    */
    readonly waitTime?: string;
}
export declare function dataConsulCatalogServiceQueryOptionsToTerraform(struct?: DataConsulCatalogServiceQueryOptions | cdktf.IResolvable): any;
export declare class DataConsulCatalogServiceQueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulCatalogServiceQueryOptions | cdktf.IResolvable | undefined;
    set internalValue(value: DataConsulCatalogServiceQueryOptions | cdktf.IResolvable | undefined);
    private _allowStale?;
    get allowStale(): boolean | cdktf.IResolvable;
    set allowStale(value: boolean | cdktf.IResolvable);
    resetAllowStale(): void;
    get allowStaleInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _near?;
    get near(): string;
    set near(value: string);
    resetNear(): void;
    get nearInput(): string | undefined;
    private _nodeMeta?;
    get nodeMeta(): {
        [key: string]: string;
    };
    set nodeMeta(value: {
        [key: string]: string;
    });
    resetNodeMeta(): void;
    get nodeMetaInput(): {
        [key: string]: string;
    } | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _requireConsistent?;
    get requireConsistent(): boolean | cdktf.IResolvable;
    set requireConsistent(value: boolean | cdktf.IResolvable);
    resetRequireConsistent(): void;
    get requireConsistentInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _waitIndex?;
    get waitIndex(): number;
    set waitIndex(value: number);
    resetWaitIndex(): void;
    get waitIndexInput(): number | undefined;
    private _waitTime?;
    get waitTime(): string;
    set waitTime(value: string);
    resetWaitTime(): void;
    get waitTimeInput(): string | undefined;
}
export declare class DataConsulCatalogServiceQueryOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataConsulCatalogServiceQueryOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulCatalogServiceQueryOptionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/catalog_service consul_catalog_service}
*/
export declare class DataConsulCatalogService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_catalog_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/catalog_service consul_catalog_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulCatalogServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulCatalogServiceConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _service;
    get service(): DataConsulCatalogServiceServiceList;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _queryOptions;
    get queryOptions(): DataConsulCatalogServiceQueryOptionsList;
    putQueryOptions(value: DataConsulCatalogServiceQueryOptions[] | cdktf.IResolvable): void;
    resetQueryOptions(): void;
    get queryOptionsInput(): cdktf.IResolvable | DataConsulCatalogServiceQueryOptions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
