import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulCatalogServicesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#id DataConsulCatalogServices#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * query_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#query_options DataConsulCatalogServices#query_options}
    */
    readonly queryOptions?: DataConsulCatalogServicesQueryOptions[] | cdktf.IResolvable;
}
export interface DataConsulCatalogServicesQueryOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#allow_stale DataConsulCatalogServices#allow_stale}
    */
    readonly allowStale?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#datacenter DataConsulCatalogServices#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#namespace DataConsulCatalogServices#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#near DataConsulCatalogServices#near}
    */
    readonly near?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#node_meta DataConsulCatalogServices#node_meta}
    */
    readonly nodeMeta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#partition DataConsulCatalogServices#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#require_consistent DataConsulCatalogServices#require_consistent}
    */
    readonly requireConsistent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#token DataConsulCatalogServices#token}
    */
    readonly token?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#wait_index DataConsulCatalogServices#wait_index}
    */
    readonly waitIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/catalog_services#wait_time DataConsulCatalogServices#wait_time}
    */
    readonly waitTime?: string;
}
export declare function dataConsulCatalogServicesQueryOptionsToTerraform(struct?: DataConsulCatalogServicesQueryOptions | cdktf.IResolvable): any;
export declare class DataConsulCatalogServicesQueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulCatalogServicesQueryOptions | cdktf.IResolvable | undefined;
    set internalValue(value: DataConsulCatalogServicesQueryOptions | cdktf.IResolvable | undefined);
    private _allowStale?;
    get allowStale(): boolean | cdktf.IResolvable;
    set allowStale(value: boolean | cdktf.IResolvable);
    resetAllowStale(): void;
    get allowStaleInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _near?;
    get near(): string;
    set near(value: string);
    resetNear(): void;
    get nearInput(): string | undefined;
    private _nodeMeta?;
    get nodeMeta(): {
        [key: string]: string;
    };
    set nodeMeta(value: {
        [key: string]: string;
    });
    resetNodeMeta(): void;
    get nodeMetaInput(): {
        [key: string]: string;
    } | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _requireConsistent?;
    get requireConsistent(): boolean | cdktf.IResolvable;
    set requireConsistent(value: boolean | cdktf.IResolvable);
    resetRequireConsistent(): void;
    get requireConsistentInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _waitIndex?;
    get waitIndex(): number;
    set waitIndex(value: number);
    resetWaitIndex(): void;
    get waitIndexInput(): number | undefined;
    private _waitTime?;
    get waitTime(): string;
    set waitTime(value: string);
    resetWaitTime(): void;
    get waitTimeInput(): string | undefined;
}
export declare class DataConsulCatalogServicesQueryOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataConsulCatalogServicesQueryOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulCatalogServicesQueryOptionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/catalog_services consul_catalog_services}
*/
export declare class DataConsulCatalogServices extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_catalog_services";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/catalog_services consul_catalog_services} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulCatalogServicesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataConsulCatalogServicesConfig);
    get datacenter(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get names(): string[];
    private _services;
    get services(): cdktf.StringMap;
    private _tags;
    get tags(): cdktf.StringMap;
    private _queryOptions;
    get queryOptions(): DataConsulCatalogServicesQueryOptionsList;
    putQueryOptions(value: DataConsulCatalogServicesQueryOptions[] | cdktf.IResolvable): void;
    resetQueryOptions(): void;
    get queryOptionsInput(): cdktf.IResolvable | DataConsulCatalogServicesQueryOptions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
