import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulNetworkSegmentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_segments#datacenter DataConsulNetworkSegments#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_segments#id DataConsulNetworkSegments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_segments#token DataConsulNetworkSegments#token}
    */
    readonly token?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/network_segments consul_network_segments}
*/
export declare class DataConsulNetworkSegments extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_network_segments";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/network_segments consul_network_segments} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulNetworkSegmentsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataConsulNetworkSegmentsConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get segments(): string[];
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
