import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulPeeringsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/peerings#id DataConsulPeerings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/peerings#partition DataConsulPeerings#partition}
    */
    readonly partition?: string;
}
export interface DataConsulPeeringsPeers {
}
export declare function dataConsulPeeringsPeersToTerraform(struct?: DataConsulPeeringsPeers): any;
export declare class DataConsulPeeringsPeersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulPeeringsPeers | undefined;
    set internalValue(value: DataConsulPeeringsPeers | undefined);
    get deletedAt(): string;
    get exportedServiceCount(): number;
    get id(): string;
    get importedServiceCount(): number;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    get partition(): string;
    get peerCaPems(): string[];
    get peerId(): string;
    get peerServerAddresses(): string[];
    get peerServerName(): string;
    get state(): string;
}
export declare class DataConsulPeeringsPeersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulPeeringsPeersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/peerings consul_peerings}
*/
export declare class DataConsulPeerings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_peerings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/peerings consul_peerings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulPeeringsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataConsulPeeringsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _peers;
    get peers(): DataConsulPeeringsPeersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
