import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulServiceHealthConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#datacenter DataConsulServiceHealth#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#filter DataConsulServiceHealth#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#id DataConsulServiceHealth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#name DataConsulServiceHealth#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#near DataConsulServiceHealth#near}
    */
    readonly near?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#node_meta DataConsulServiceHealth#node_meta}
    */
    readonly nodeMeta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#passing DataConsulServiceHealth#passing}
    */
    readonly passing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#tag DataConsulServiceHealth#tag}
    */
    readonly tag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/service_health#wait_for DataConsulServiceHealth#wait_for}
    */
    readonly waitFor?: string;
}
export interface DataConsulServiceHealthResultsChecks {
}
export declare function dataConsulServiceHealthResultsChecksToTerraform(struct?: DataConsulServiceHealthResultsChecks): any;
export declare class DataConsulServiceHealthResultsChecksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulServiceHealthResultsChecks | undefined;
    set internalValue(value: DataConsulServiceHealthResultsChecks | undefined);
    get id(): string;
    get name(): string;
    get nodeAttribute(): string;
    get notes(): string;
    get output(): string;
    get serviceId(): string;
    get serviceName(): string;
    get serviceTags(): string[];
    get status(): string;
}
export declare class DataConsulServiceHealthResultsChecksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulServiceHealthResultsChecksOutputReference;
}
export interface DataConsulServiceHealthResultsNode {
}
export declare function dataConsulServiceHealthResultsNodeToTerraform(struct?: DataConsulServiceHealthResultsNode): any;
export declare class DataConsulServiceHealthResultsNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulServiceHealthResultsNode | undefined;
    set internalValue(value: DataConsulServiceHealthResultsNode | undefined);
    get address(): string;
    get datacenter(): string;
    get id(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    private _taggedAddresses;
    get taggedAddresses(): cdktf.StringMap;
}
export declare class DataConsulServiceHealthResultsNodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulServiceHealthResultsNodeOutputReference;
}
export interface DataConsulServiceHealthResultsService {
}
export declare function dataConsulServiceHealthResultsServiceToTerraform(struct?: DataConsulServiceHealthResultsService): any;
export declare class DataConsulServiceHealthResultsServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulServiceHealthResultsService | undefined;
    set internalValue(value: DataConsulServiceHealthResultsService | undefined);
    get address(): string;
    get id(): string;
    private _meta;
    get meta(): cdktf.StringMap;
    get name(): string;
    get port(): number;
    get tags(): string[];
}
export declare class DataConsulServiceHealthResultsServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulServiceHealthResultsServiceOutputReference;
}
export interface DataConsulServiceHealthResults {
}
export declare function dataConsulServiceHealthResultsToTerraform(struct?: DataConsulServiceHealthResults): any;
export declare class DataConsulServiceHealthResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulServiceHealthResults | undefined;
    set internalValue(value: DataConsulServiceHealthResults | undefined);
    private _checks;
    get checks(): DataConsulServiceHealthResultsChecksList;
    private _node;
    get nodeAttribute(): DataConsulServiceHealthResultsNodeList;
    private _service;
    get service(): DataConsulServiceHealthResultsServiceList;
}
export declare class DataConsulServiceHealthResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulServiceHealthResultsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/service_health consul_service_health}
*/
export declare class DataConsulServiceHealth extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_service_health";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/service_health consul_service_health} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulServiceHealthConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulServiceHealthConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _near?;
    get near(): string;
    set near(value: string);
    resetNear(): void;
    get nearInput(): string | undefined;
    private _nodeMeta?;
    get nodeMeta(): {
        [key: string]: string;
    };
    set nodeMeta(value: {
        [key: string]: string;
    });
    resetNodeMeta(): void;
    get nodeMetaInput(): {
        [key: string]: string;
    } | undefined;
    private _passing?;
    get passing(): boolean | cdktf.IResolvable;
    set passing(value: boolean | cdktf.IResolvable);
    resetPassing(): void;
    get passingInput(): boolean | cdktf.IResolvable | undefined;
    private _results;
    get results(): DataConsulServiceHealthResultsList;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _waitFor?;
    get waitFor(): string;
    set waitFor(value: string);
    resetWaitFor(): void;
    get waitForInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
