import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IntentionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#action Intention#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#datacenter Intention#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#description Intention#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#destination_name Intention#destination_name}
    */
    readonly destinationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#destination_namespace Intention#destination_namespace}
    */
    readonly destinationNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#id Intention#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#meta Intention#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#source_name Intention#source_name}
    */
    readonly sourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/intention#source_namespace Intention#source_namespace}
    */
    readonly sourceNamespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/intention consul_intention}
*/
export declare class Intention extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_intention";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/intention consul_intention} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IntentionConfig
    */
    constructor(scope: Construct, id: string, config: IntentionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationName?;
    get destinationName(): string;
    set destinationName(value: string);
    get destinationNameInput(): string | undefined;
    private _destinationNamespace?;
    get destinationNamespace(): string;
    set destinationNamespace(value: string);
    resetDestinationNamespace(): void;
    get destinationNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _sourceName?;
    get sourceName(): string;
    set sourceName(value: string);
    get sourceNameInput(): string | undefined;
    private _sourceNamespace?;
    get sourceNamespace(): string;
    set sourceNamespace(value: string);
    resetSourceNamespace(): void;
    get sourceNamespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
