import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#datacenter KeyPrefix#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#id KeyPrefix#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#namespace KeyPrefix#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#partition KeyPrefix#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#path_prefix KeyPrefix#path_prefix}
    */
    readonly pathPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#subkeys KeyPrefix#subkeys}
    */
    readonly subkeys?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#token KeyPrefix#token}
    */
    readonly token?: string;
    /**
    * subkey block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#subkey KeyPrefix#subkey}
    */
    readonly subkey?: KeyPrefixSubkey[] | cdktf.IResolvable;
}
export interface KeyPrefixSubkey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#flags KeyPrefix#flags}
    */
    readonly flags?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#path KeyPrefix#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/key_prefix#value KeyPrefix#value}
    */
    readonly value: string;
}
export declare function keyPrefixSubkeyToTerraform(struct?: KeyPrefixSubkey | cdktf.IResolvable): any;
export declare class KeyPrefixSubkeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyPrefixSubkey | cdktf.IResolvable | undefined;
    set internalValue(value: KeyPrefixSubkey | cdktf.IResolvable | undefined);
    private _flags?;
    get flags(): number;
    set flags(value: number);
    resetFlags(): void;
    get flagsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class KeyPrefixSubkeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KeyPrefixSubkey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyPrefixSubkeyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/key_prefix consul_key_prefix}
*/
export declare class KeyPrefix extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_key_prefix";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/key_prefix consul_key_prefix} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyPrefixConfig
    */
    constructor(scope: Construct, id: string, config: KeyPrefixConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _pathPrefix?;
    get pathPrefix(): string;
    set pathPrefix(value: string);
    get pathPrefixInput(): string | undefined;
    private _subkeys?;
    get subkeys(): {
        [key: string]: string;
    };
    set subkeys(value: {
        [key: string]: string;
    });
    resetSubkeys(): void;
    get subkeysInput(): {
        [key: string]: string;
    } | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _subkey;
    get subkey(): KeyPrefixSubkeyList;
    putSubkey(value: KeyPrefixSubkey[] | cdktf.IResolvable): void;
    resetSubkey(): void;
    get subkeyInput(): cdktf.IResolvable | KeyPrefixSubkey[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
