import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PeeringTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering_token#id PeeringToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering_token#meta PeeringToken#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering_token#partition PeeringToken#partition}
    */
    readonly partition?: string;
    /**
    * The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering_token#peer_name PeeringToken#peer_name}
    */
    readonly peerName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/peering_token consul_peering_token}
*/
export declare class PeeringToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_peering_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/peering_token consul_peering_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PeeringTokenConfig
    */
    constructor(scope: Construct, id: string, config: PeeringTokenConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _peerName?;
    get peerName(): string;
    set peerName(value: string);
    get peerNameInput(): string | undefined;
    get peeringToken(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
