import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering#id Peering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering#meta Peering#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering#partition Peering#partition}
    */
    readonly partition?: string;
    /**
    * The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering#peer_name Peering#peer_name}
    */
    readonly peerName: string;
    /**
    * The peering token fetched from the peer cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/peering#peering_token Peering#peering_token}
    */
    readonly peeringToken: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/peering consul_peering}
*/
export declare class Peering extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/peering consul_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PeeringConfig
    */
    constructor(scope: Construct, id: string, config: PeeringConfig);
    get deletedAt(): string;
    get exportedServiceCount(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get importedServiceCount(): number;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    get peerCaPems(): string[];
    get peerId(): string;
    private _peerName?;
    get peerName(): string;
    set peerName(value: string);
    get peerNameInput(): string | undefined;
    get peerServerAddresses(): string[];
    get peerServerName(): string;
    private _peeringToken?;
    get peeringToken(): string;
    set peeringToken(value: string);
    get peeringTokenInput(): string | undefined;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
