import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsulProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#address ConsulProvider#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#ca_file ConsulProvider#ca_file}
    */
    readonly caFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#ca_path ConsulProvider#ca_path}
    */
    readonly caPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#ca_pem ConsulProvider#ca_pem}
    */
    readonly caPem?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#cert_file ConsulProvider#cert_file}
    */
    readonly certFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#cert_pem ConsulProvider#cert_pem}
    */
    readonly certPem?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#datacenter ConsulProvider#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#http_auth ConsulProvider#http_auth}
    */
    readonly httpAuth?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#insecure_https ConsulProvider#insecure_https}
    */
    readonly insecureHttps?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#key_file ConsulProvider#key_file}
    */
    readonly keyFile?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#key_pem ConsulProvider#key_pem}
    */
    readonly keyPem?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#namespace ConsulProvider#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#scheme ConsulProvider#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#token ConsulProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#alias ConsulProvider#alias}
    */
    readonly alias?: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#header ConsulProvider#header}
    */
    readonly header?: ConsulProviderHeader[] | cdktf.IResolvable;
}
export interface ConsulProviderHeader {
    /**
    * The header name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#name ConsulProvider#name}
    */
    readonly name: string;
    /**
    * The header value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul#value ConsulProvider#value}
    */
    readonly value: string;
}
export declare function consulProviderHeaderToTerraform(struct?: ConsulProviderHeader | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul consul}
*/
export declare class ConsulProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "consul";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul consul} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsulProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ConsulProviderConfig);
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _caFile?;
    get caFile(): string | undefined;
    set caFile(value: string | undefined);
    resetCaFile(): void;
    get caFileInput(): string | undefined;
    private _caPath?;
    get caPath(): string | undefined;
    set caPath(value: string | undefined);
    resetCaPath(): void;
    get caPathInput(): string | undefined;
    private _caPem?;
    get caPem(): string | undefined;
    set caPem(value: string | undefined);
    resetCaPem(): void;
    get caPemInput(): string | undefined;
    private _certFile?;
    get certFile(): string | undefined;
    set certFile(value: string | undefined);
    resetCertFile(): void;
    get certFileInput(): string | undefined;
    private _certPem?;
    get certPem(): string | undefined;
    set certPem(value: string | undefined);
    resetCertPem(): void;
    get certPemInput(): string | undefined;
    private _datacenter?;
    get datacenter(): string | undefined;
    set datacenter(value: string | undefined);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _httpAuth?;
    get httpAuth(): string | undefined;
    set httpAuth(value: string | undefined);
    resetHttpAuth(): void;
    get httpAuthInput(): string | undefined;
    private _insecureHttps?;
    get insecureHttps(): boolean | cdktf.IResolvable | undefined;
    set insecureHttps(value: boolean | cdktf.IResolvable | undefined);
    resetInsecureHttps(): void;
    get insecureHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _keyFile?;
    get keyFile(): string | undefined;
    set keyFile(value: string | undefined);
    resetKeyFile(): void;
    get keyFileInput(): string | undefined;
    private _keyPem?;
    get keyPem(): string | undefined;
    set keyPem(value: string | undefined);
    resetKeyPem(): void;
    get keyPemInput(): string | undefined;
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _scheme?;
    get scheme(): string | undefined;
    set scheme(value: string | undefined);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _header?;
    get header(): ConsulProviderHeader[] | cdktf.IResolvable | undefined;
    set header(value: ConsulProviderHeader[] | cdktf.IResolvable | undefined);
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ConsulProviderHeader[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
