pynbody
=======
[![Build Status](https://github.com/pynbody/pynbody/actions/workflows/build-test.yaml/badge.svg?branch=master)](https://github.com/pynbody/pynbody/actions)

[Pynbody](https://github.com/pynbody/pynbody) is a light-weight,
portable, format-transparent analysis framework for N-body and
hydrodynamic astrophysical simulations supporting PKDGRAV/Gasoline,
Gadget, N-Chilada, and RAMSES AMR outputs. 

Written in Python, the core tools are accompanied by a library of
publication-level analysis routines. For a quick tour of some of 
the features, have a look at this [IPython notebook](http://nbviewer.ipython.org/github/pynbody/pynbody/blob/master/examples/pynbody_demo.ipynb).

*Since August 2020, pynbody supports only Python 3.5 or later*. To reflect this change, we are moving to a new semantic version numbering scheme, starting with 1.0.0.  Earlier versions of pynbody (prior to 1.0) can be installed for users who are still transitioning away from Python 2, support for which ended in January 2020.


### Getting started 

If python and the standard pip package manager is installed and properly configured, you can simply do:

```
$ pip install pynbody
```

If this fails, you may need some more detailed [installation
instructions](http://pynbody.github.io/pynbody/installation.html). Once
you have the package installed, try the introductory
[tutorials](http://pynbody.github.io/pynbody/tutorials/tutorials.html).
The full documentation can be found
[here](http://pynbody.github.io/pynbody/).

### Contributing 

Help us make *pynbody* better! As you develop analysis for your science with pynbody, consider making your code available for everyone else to use. You can do this by creating a [tutorial](http://pynbody.github.io/pynbody/tutorials/tutorials.html) or [cookbook](http://pynbody.github.io/pynbody/tutorials/tutorials.html#cookbook-recipes) or by adding your code to the relevant sub-module and submitting a pull request (make a fork first -- see https://help.github.com/articles/using-pull-requests). 


### Acknowledging the code

When using pynbody, please acknowledge it by citing the [Astrophysics Source Code Library entry](http://adsabs.harvard.edu/abs/2013ascl.soft05002P). Optionally you can also cite the Zenodo DOI for the specific version of pynbody that you are using, which may be found [here](https://doi.org/10.5281/zenodo.1297087).

### Support and Contact 

If you have trouble with Pynbody or you have feature
requests/suggestions you can [submit an issue](https://github.com/pynbody/pynbody/issues), 
and/or send us an email on the [Usergroup mailing
list](https://groups.google.com/forum/?fromgroups#!forum/pynbody-users).


