import numpy as np

import materia

from .dataseries import SPDSpectrum


class SimmonsDSeriesPCA0(SPDSpectrum):
    def __init__(self):
        # data taken from https://web.archive.org/web/20170131100357/http://files.cie.co.at/204.xls
        x = materia.Qty(value=np.linspace(300, 830, 107), unit=materia.nanometer)

        S0 = [
            0.04,
            3.02,
            6.00,
            17.80,
            29.60,
            42.45,
            55.30,
            56.30,
            57.30,
            59.55,
            61.80,
            61.65,
            61.50,
            65.15,
            68.80,
            66.10,
            63.40,
            64.60,
            65.80,
            80.30,
            94.80,
            99.80,
            104.80,
            105.35,
            105.90,
            101.35,
            96.80,
            105.35,
            113.90,
            119.75,
            125.60,
            125.55,
            125.50,
            123.40,
            121.30,
            121.30,
            121.30,
            117.40,
            113.50,
            113.30,
            113.10,
            111.95,
            110.80,
            108.65,
            106.50,
            107.65,
            108.80,
            107.05,
            105.30,
            104.85,
            104.40,
            102.20,
            100.00,
            98.00,
            96.00,
            95.55,
            95.10,
            92.10,
            89.10,
            89.80,
            90.50,
            90.40,
            90.30,
            89.35,
            88.40,
            86.20,
            84.00,
            84.55,
            85.10,
            83.50,
            81.90,
            82.25,
            82.60,
            83.75,
            84.90,
            83.10,
            81.30,
            76.60,
            71.90,
            73.10,
            74.30,
            75.35,
            76.40,
            69.85,
            63.30,
            67.50,
            71.70,
            74.35,
            77.00,
            71.10,
            65.20,
            56.45,
            47.70,
            58.15,
            68.60,
            66.80,
            65.00,
            65.50,
            66.00,
            63.50,
            61.00,
            57.15,
            53.30,
            56.10,
            58.90,
            60.40,
            61.90,
        ]
        y = materia.Qty(value=np.array(S0), unit=materia.unitless)

        super().__init__(x=x, y=y)


class SimmonsDSeriesPCA1(SPDSpectrum):
    def __init__(self):
        # data taken from https://web.archive.org/web/20170131100357/http://files.cie.co.at/204.xls
        x = materia.Qty(value=np.linspace(300, 830, 107), unit=materia.nanometer)

        S1 = [
            0.02,
            2.26,
            4.50,
            13.45,
            22.40,
            32.20,
            42.00,
            41.30,
            40.60,
            41.10,
            41.60,
            39.80,
            38.00,
            40.20,
            42.40,
            40.45,
            38.50,
            36.75,
            35.00,
            39.20,
            43.40,
            44.85,
            46.30,
            45.10,
            43.90,
            40.50,
            37.10,
            36.90,
            36.70,
            36.30,
            35.90,
            34.25,
            32.60,
            30.25,
            27.90,
            26.10,
            24.30,
            22.20,
            20.10,
            18.15,
            16.20,
            14.70,
            13.20,
            10.90,
            8.60,
            7.35,
            6.10,
            5.15,
            4.20,
            3.05,
            1.90,
            0.95,
            0.00,
            -0.80,
            -1.60,
            -2.55,
            -3.50,
            -3.50,
            -3.50,
            -4.65,
            -5.80,
            -6.50,
            -7.20,
            -7.90,
            -8.60,
            -9.05,
            -9.50,
            -10.20,
            -10.90,
            -10.80,
            -10.70,
            -11.35,
            -12.00,
            -13.00,
            -14.00,
            -13.80,
            -13.60,
            -12.80,
            -12.00,
            -12.65,
            -13.30,
            -13.10,
            -12.90,
            -11.75,
            -10.60,
            -11.10,
            -11.60,
            -11.90,
            -12.20,
            -11.20,
            -10.20,
            -9.00,
            -7.80,
            -9.50,
            -11.20,
            -10.80,
            -10.40,
            -10.50,
            -10.60,
            -10.15,
            -9.70,
            -9.00,
            -8.30,
            -8.80,
            -9.30,
            -9.55,
            -9.80,
        ]
        y = materia.Qty(value=np.array(S1), unit=materia.unitless)

        super().__init__(x=x, y=y)


class SimmonsDSeriesPCA2(SPDSpectrum):
    def __init__(self):
        # data taken from https://web.archive.org/web/20170131100357/http://files.cie.co.at/204.xls
        x = materia.Qty(value=np.linspace(300, 830, 107), unit=materia.nanometer)

        S2 = [
            0.00,
            1.00,
            2.00,
            3.00,
            4.00,
            6.25,
            8.50,
            8.15,
            7.80,
            7.25,
            6.70,
            6.00,
            5.30,
            5.70,
            6.10,
            4.55,
            3.00,
            2.10,
            1.20,
            0.05,
            -1.10,
            -0.80,
            -0.50,
            -0.60,
            -0.70,
            -0.95,
            -1.20,
            -1.90,
            -2.60,
            -2.75,
            -2.90,
            -2.85,
            -2.80,
            -2.70,
            -2.60,
            -2.60,
            -2.60,
            -2.20,
            -1.80,
            -1.65,
            -1.50,
            -1.40,
            -1.30,
            -1.25,
            -1.20,
            -1.10,
            -1.00,
            -0.75,
            -0.50,
            -0.40,
            -0.30,
            -0.15,
            0.00,
            0.10,
            0.20,
            0.35,
            0.50,
            1.30,
            2.10,
            2.65,
            3.20,
            3.65,
            4.10,
            4.40,
            4.70,
            4.90,
            5.10,
            5.90,
            6.70,
            7.00,
            7.30,
            7.95,
            8.60,
            9.20,
            9.80,
            10.00,
            10.20,
            9.25,
            8.30,
            8.95,
            9.60,
            9.05,
            8.50,
            7.75,
            7.00,
            7.30,
            7.60,
            7.80,
            8.00,
            7.35,
            6.70,
            5.95,
            5.20,
            6.30,
            7.40,
            7.10,
            6.80,
            6.90,
            7.00,
            6.70,
            6.40,
            5.95,
            5.50,
            5.80,
            6.10,
            6.30,
            6.50,
        ]
        y = materia.Qty(value=np.array(S2), unit=materia.unitless)

        super().__init__(x=x, y=y)
