# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
from enum import Enum, unique
import random
import string


@unique
class IDTypes(Enum):
    projects = "prj"
    snapshots = "sna"
    users = "usr"
    organizations = "org"
    organization_invitations = "orginv"
    sessions = "ses"
    applied_snapshots = "asn"
    clouds = "cld"
    permissions_projects = "ppr"
    permissions_sessions = "pse"
    permissions_snapshots = "psn"
    permissions_clouds = "pcl"
    permissions_organizations = "por"
    identities = "ide"
    autosync_sessions = "aus"
    session_state_transitions = "sst"
    server_sessions = "sss"
    session_commands = "scd"
    instances = "ins"
    instances_unique = "asi"
    application_templates = "apt"
    builds = "bld"
    session_operations = "sop"
    compute_templates = "cpt"
    usage_snapshots = "usp"
    usage_export_jobs = "uej"
    namespaces = "nsp"
    runtime_environments = "rte"
    actors = "act"
    jobs = "job"
    anonymous_jobs = "ajb"
    anonymous_actors = "aac"
    sso_configs = "sso"


class IDGenerator:
    def __init__(self, type: IDTypes):
        self.type = type.value

        self.rand = random.SystemRandom()
        self.possible_characters = list(
            set(string.ascii_letters + string.digits)
            - {"I", "l", "o", "O", "0"}  # No confusing characters # noqa: W503
        )

    def generate_id(self) -> str:
        id_part = "".join(self.rand.choices(self.possible_characters, k=24))
        return f"{self.type}_{id_part}"


# Use this to avoid global variables due to cloudpickle not having great support for them.
def generate_id(type: IDTypes) -> str:
    generator = IDGenerator(type)
    return generator.generate_id()
