import { PolicyDocument } from '@aws-cdk/aws-iam';
import { Construct, Resource } from '@aws-cdk/core';
import { ITopic } from './topic-base';
export interface TopicPolicyProps {
    /**
     * The set of topics this policy applies to.
     */
    readonly topics: ITopic[];
}
/**
 * Applies a policy to SNS topics.
 */
export declare class TopicPolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     */
    readonly document: PolicyDocument;
    constructor(scope: Construct, id: string, props: TopicPolicyProps);
}
