def get_ogham_mapping() -> 'dict[str, str]':
    mapping = {
        "᚛": "",
        "᚜": "",
        "ᚁ": "b",
        "ᚂ": "l",
        "ᚃ": "v",
        "ᚄ": "s",
        "ᚅ": "n",
        "ᚆ": "h",
        "ᚇ": "d",
        "ᚈ": "t",
        "ᚉ": "c",
        "ᚊ": "q",
        "ᚋ": "m",
        "ᚌ": "g",
        "ᚍ": "ng",
        "ᚎ": "z",
        "ᚏ": "r",
        "ᚐ": "a",
        "ᚑ": "o",
        "ᚒ": "u",
        "ᚓ": "e",
        "ᚔ": "i",
        "ᚕ": "k",
        "ᚖ": "oi",
        "ᚗ": "ui",
        "ᚘ": "io",
        "ᚙ": "ai",
        "ᚚ": "p",
        " ": " ",
    }

    return mapping

def get_letter_mapping() -> 'dict[str, str]':
    mapping = {
        "a": "ᚐ",
        "á": "ᚐ",
        "b": "ᚁ",
        "c": "ᚉ",
        "d": "ᚇ",
        "ð": "ᚇ",
        "e": "ᚓ",
        "é": "ᚓ",
        "f": "ᚃ",
        "g": "ᚌ",
        "h": "ᚆ",
        "i": "ᚔ",
        "í": "ᚔ",
        "j": "ᚌ",
        "k": "ᚕ",
        "l": "ᚂ",
        "m": "ᚋ",
        "n": "ᚅ",
        "o": "ᚑ",
        "ó": "ᚑ",
        "p": "ᚚ",
        "q": "ᚊ",
        "r": "ᚏ",
        "s": "ᚄ",
        "t": "ᚈ",
        "þ": "ᚈ",
        "u": "ᚒ",
        "ú": "ᚒ",
        "v": "ᚃ",
        "w": "ᚃ",
        "x": "ᚎ",
        "y": "ᚔ",
        "ý": "ᚔ",
        "z": "ᚎ",
        "å": "ᚑ",
        "ä": "ᚙ",
        "æ": "ᚙ",
        "ö": "ᚑ",
        "ø": "ᚑ",
        "ǫ": "ᚑ",
        "oi": "ᚖ",
        "ui": "ᚗ",
        "io": "ᚘ",
        "ai": "ᚙ",
        " ": " ",
    }

    return mapping

def get_dual_letter_mapping() -> 'dict[str, str]':
    mapping = {
        "oi": "ᚖ",
        "ui": "ᚗ",
        "io": "ᚘ",
        "ai": "ᚙ",
    }

    return mapping