import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainTrustConfig extends cdktf.TerraformMetaArguments {
    /**
     * The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions,  https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#domain ActiveDirectoryDomainTrust#domain}
     *
     * @stability stable
     */
    readonly domain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#project ActiveDirectoryDomainTrust#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Whether the trusted side has forest/domain wide access or selective access to an approved set of resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#selective_authentication ActiveDirectoryDomainTrust#selective_authentication}
     *
     * @stability stable
     */
    readonly selectiveAuthentication?: boolean | cdktf.IResolvable;
    /**
     * The target DNS server IP addresses which can resolve the remote domain involved in the trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#target_dns_ip_addresses ActiveDirectoryDomainTrust#target_dns_ip_addresses}
     *
     * @stability stable
     */
    readonly targetDnsIpAddresses: string[];
    /**
     * The fully qualified target domain name which will be in trust with the current domain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#target_domain_name ActiveDirectoryDomainTrust#target_domain_name}
     *
     * @stability stable
     */
    readonly targetDomainName: string;
    /**
     * The trust direction, which decides if the current domain is trusted, trusting, or both. Possible values: ["INBOUND", "OUTBOUND", "BIDIRECTIONAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#trust_direction ActiveDirectoryDomainTrust#trust_direction}
     *
     * @stability stable
     */
    readonly trustDirection: string;
    /**
     * The trust secret used for the handshake with the target domain. This will not be stored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#trust_handshake_secret ActiveDirectoryDomainTrust#trust_handshake_secret}
     *
     * @stability stable
     */
    readonly trustHandshakeSecret: string;
    /**
     * The type of trust represented by the trust resource. Possible values: ["FOREST", "EXTERNAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#trust_type ActiveDirectoryDomainTrust#trust_type}
     *
     * @stability stable
     */
    readonly trustType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#timeouts ActiveDirectoryDomainTrust#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ActiveDirectoryDomainTrustTimeouts;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainTrustTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#create ActiveDirectoryDomainTrust#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#delete ActiveDirectoryDomainTrust#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust#update ActiveDirectoryDomainTrust#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function activeDirectoryDomainTrustTimeoutsToTerraform(struct?: ActiveDirectoryDomainTrustTimeoutsOutputReference | ActiveDirectoryDomainTrustTimeouts): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainTrustTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainTrustTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainTrustTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust google_active_directory_domain_trust}.
 *
 * @stability stable
 */
export declare class ActiveDirectoryDomainTrust extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/active_directory_domain_trust google_active_directory_domain_trust} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainTrustConfig);
    private _domain?;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    set domain(value: string);
    /**
     * @stability stable
     */
    get domainInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _selectiveAuthentication?;
    /**
     * @stability stable
     */
    get selectiveAuthentication(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set selectiveAuthentication(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSelectiveAuthentication(): void;
    /**
     * @stability stable
     */
    get selectiveAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _targetDnsIpAddresses?;
    /**
     * @stability stable
     */
    get targetDnsIpAddresses(): string[];
    /**
     * @stability stable
     */
    set targetDnsIpAddresses(value: string[]);
    /**
     * @stability stable
     */
    get targetDnsIpAddressesInput(): string[] | undefined;
    private _targetDomainName?;
    /**
     * @stability stable
     */
    get targetDomainName(): string;
    /**
     * @stability stable
     */
    set targetDomainName(value: string);
    /**
     * @stability stable
     */
    get targetDomainNameInput(): string | undefined;
    private _trustDirection?;
    /**
     * @stability stable
     */
    get trustDirection(): string;
    /**
     * @stability stable
     */
    set trustDirection(value: string);
    /**
     * @stability stable
     */
    get trustDirectionInput(): string | undefined;
    private _trustHandshakeSecret?;
    /**
     * @stability stable
     */
    get trustHandshakeSecret(): string;
    /**
     * @stability stable
     */
    set trustHandshakeSecret(value: string);
    /**
     * @stability stable
     */
    get trustHandshakeSecretInput(): string | undefined;
    private _trustType?;
    /**
     * @stability stable
     */
    get trustType(): string;
    /**
     * @stability stable
     */
    set trustType(value: string);
    /**
     * @stability stable
     */
    get trustTypeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ActiveDirectoryDomainTrustTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ActiveDirectoryDomainTrustTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ActiveDirectoryDomainTrustTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
