import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the job.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#job_id BigqueryJob#job_id}
     *
     * @stability stable
     */
    readonly jobId: string;
    /**
     * Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#job_timeout_ms BigqueryJob#job_timeout_ms}
     *
     * @stability stable
     */
    readonly jobTimeoutMs?: string;
    /**
     * The labels associated with this job. You can use these to organize and group your jobs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#labels BigqueryJob#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The geographic location of the job. The default value is US.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#location BigqueryJob#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project BigqueryJob#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * copy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#copy BigqueryJob#copy}
     *
     * @stability stable
     */
    readonly copy?: BigqueryJobCopy;
    /**
     * extract block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#extract BigqueryJob#extract}
     *
     * @stability stable
     */
    readonly extract?: BigqueryJobExtract;
    /**
     * load block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#load BigqueryJob#load}
     *
     * @stability stable
     */
    readonly load?: BigqueryJobLoad;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#query BigqueryJob#query}
     *
     * @stability stable
     */
    readonly query?: BigqueryJobQuery;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#timeouts BigqueryJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryJobTimeouts;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatusErrorResult extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatusErrors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get reason(): string;
}
/**
 * @stability stable
 */
export declare class BigqueryJobStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get errorResult(): any;
    /**
     * @stability stable
     */
    get errors(): any;
    /**
     * @stability stable
     */
    get state(): string;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopyDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function bigqueryJobCopyDestinationEncryptionConfigurationToTerraform(struct?: BigqueryJobCopyDestinationEncryptionConfigurationOutputReference | BigqueryJobCopyDestinationEncryptionConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryJobCopyDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobCopyDestinationEncryptionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobCopyDestinationEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopyDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryJobCopyDestinationTableToTerraform(struct?: BigqueryJobCopyDestinationTableOutputReference | BigqueryJobCopyDestinationTable): any;
/**
 * @stability stable
 */
export declare class BigqueryJobCopyDestinationTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobCopyDestinationTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobCopyDestinationTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    resetDatasetId(): void;
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobCopySourceTables {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryJobCopySourceTablesToTerraform(struct?: BigqueryJobCopySourceTables): any;
/**
 * @stability stable
 */
export interface BigqueryJobCopy {
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobCopyDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable?: BigqueryJobCopyDestinationTable;
    /**
     * source_tables block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#source_tables BigqueryJob#source_tables}
     *
     * @stability stable
     */
    readonly sourceTables: BigqueryJobCopySourceTables[];
}
export declare function bigqueryJobCopyToTerraform(struct?: BigqueryJobCopyOutputReference | BigqueryJobCopy): any;
/**
 * @stability stable
 */
export declare class BigqueryJobCopyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobCopy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobCopy | undefined);
    private _createDisposition?;
    /**
     * @stability stable
     */
    get createDisposition(): string;
    /**
     * @stability stable
     */
    set createDisposition(value: string);
    /**
     * @stability stable
     */
    resetCreateDisposition(): void;
    /**
     * @stability stable
     */
    get createDispositionInput(): string | undefined;
    private _writeDisposition?;
    /**
     * @stability stable
     */
    get writeDisposition(): string;
    /**
     * @stability stable
     */
    set writeDisposition(value: string);
    /**
     * @stability stable
     */
    resetWriteDisposition(): void;
    /**
     * @stability stable
     */
    get writeDispositionInput(): string | undefined;
    private _destinationEncryptionConfiguration;
    /**
     * @stability stable
     */
    get destinationEncryptionConfiguration(): BigqueryJobCopyDestinationEncryptionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putDestinationEncryptionConfiguration(value: BigqueryJobCopyDestinationEncryptionConfiguration): void;
    /**
     * @stability stable
     */
    resetDestinationEncryptionConfiguration(): void;
    /**
     * @stability stable
     */
    get destinationEncryptionConfigurationInput(): BigqueryJobCopyDestinationEncryptionConfiguration | undefined;
    private _destinationTable;
    /**
     * @stability stable
     */
    get destinationTable(): BigqueryJobCopyDestinationTableOutputReference;
    /**
     * @stability stable
     */
    putDestinationTable(value: BigqueryJobCopyDestinationTable): void;
    /**
     * @stability stable
     */
    resetDestinationTable(): void;
    /**
     * @stability stable
     */
    get destinationTableInput(): BigqueryJobCopyDestinationTable | undefined;
    private _sourceTables?;
    /**
     * @stability stable
     */
    get sourceTables(): BigqueryJobCopySourceTables[];
    /**
     * @stability stable
     */
    set sourceTables(value: BigqueryJobCopySourceTables[]);
    /**
     * @stability stable
     */
    get sourceTablesInput(): BigqueryJobCopySourceTables[] | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobExtractSourceModel {
    /**
     * The ID of the dataset containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#model_id BigqueryJob#model_id}
     *
     * @stability stable
     */
    readonly modelId: string;
    /**
     * The ID of the project containing this model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
export declare function bigqueryJobExtractSourceModelToTerraform(struct?: BigqueryJobExtractSourceModelOutputReference | BigqueryJobExtractSourceModel): any;
/**
 * @stability stable
 */
export declare class BigqueryJobExtractSourceModelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobExtractSourceModel | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobExtractSourceModel | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _modelId?;
    /**
     * @stability stable
     */
    get modelId(): string;
    /**
     * @stability stable
     */
    set modelId(value: string);
    /**
     * @stability stable
     */
    get modelIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobExtractSourceTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryJobExtractSourceTableToTerraform(struct?: BigqueryJobExtractSourceTableOutputReference | BigqueryJobExtractSourceTable): any;
/**
 * @stability stable
 */
export declare class BigqueryJobExtractSourceTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobExtractSourceTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobExtractSourceTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    resetDatasetId(): void;
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobExtract {
    /**
     * The compression type to use for exported files.
     *
     * Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
     * The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#compression BigqueryJob#compression}
     *
     * @stability stable
     */
    readonly compression?: string;
    /**
     * The exported file format.
     *
     * Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
     * The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
     * The default value for models is SAVED_MODEL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_format BigqueryJob#destination_format}
     *
     * @stability stable
     */
    readonly destinationFormat?: string;
    /**
     * A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_uris BigqueryJob#destination_uris}
     *
     * @stability stable
     */
    readonly destinationUris: string[];
    /**
     * When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
     *
     * Default is ','
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#field_delimiter BigqueryJob#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Whether to print out a header row in the results. Default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#print_header BigqueryJob#print_header}
     *
     * @stability stable
     */
    readonly printHeader?: boolean | cdktf.IResolvable;
    /**
     * Whether to use logical types when extracting to AVRO format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_avro_logical_types BigqueryJob#use_avro_logical_types}
     *
     * @stability stable
     */
    readonly useAvroLogicalTypes?: boolean | cdktf.IResolvable;
    /**
     * source_model block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#source_model BigqueryJob#source_model}
     *
     * @stability stable
     */
    readonly sourceModel?: BigqueryJobExtractSourceModel;
    /**
     * source_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#source_table BigqueryJob#source_table}
     *
     * @stability stable
     */
    readonly sourceTable?: BigqueryJobExtractSourceTable;
}
export declare function bigqueryJobExtractToTerraform(struct?: BigqueryJobExtractOutputReference | BigqueryJobExtract): any;
/**
 * @stability stable
 */
export declare class BigqueryJobExtractOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobExtract | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobExtract | undefined);
    private _compression?;
    /**
     * @stability stable
     */
    get compression(): string;
    /**
     * @stability stable
     */
    set compression(value: string);
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): string | undefined;
    private _destinationFormat?;
    /**
     * @stability stable
     */
    get destinationFormat(): string;
    /**
     * @stability stable
     */
    set destinationFormat(value: string);
    /**
     * @stability stable
     */
    resetDestinationFormat(): void;
    /**
     * @stability stable
     */
    get destinationFormatInput(): string | undefined;
    private _destinationUris?;
    /**
     * @stability stable
     */
    get destinationUris(): string[];
    /**
     * @stability stable
     */
    set destinationUris(value: string[]);
    /**
     * @stability stable
     */
    get destinationUrisInput(): string[] | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _printHeader?;
    /**
     * @stability stable
     */
    get printHeader(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set printHeader(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrintHeader(): void;
    /**
     * @stability stable
     */
    get printHeaderInput(): boolean | cdktf.IResolvable | undefined;
    private _useAvroLogicalTypes?;
    /**
     * @stability stable
     */
    get useAvroLogicalTypes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useAvroLogicalTypes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseAvroLogicalTypes(): void;
    /**
     * @stability stable
     */
    get useAvroLogicalTypesInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceModel;
    /**
     * @stability stable
     */
    get sourceModel(): BigqueryJobExtractSourceModelOutputReference;
    /**
     * @stability stable
     */
    putSourceModel(value: BigqueryJobExtractSourceModel): void;
    /**
     * @stability stable
     */
    resetSourceModel(): void;
    /**
     * @stability stable
     */
    get sourceModelInput(): BigqueryJobExtractSourceModel | undefined;
    private _sourceTable;
    /**
     * @stability stable
     */
    get sourceTable(): BigqueryJobExtractSourceTableOutputReference;
    /**
     * @stability stable
     */
    putSourceTable(value: BigqueryJobExtractSourceTable): void;
    /**
     * @stability stable
     */
    resetSourceTable(): void;
    /**
     * @stability stable
     */
    get sourceTableInput(): BigqueryJobExtractSourceTable | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function bigqueryJobLoadDestinationEncryptionConfigurationToTerraform(struct?: BigqueryJobLoadDestinationEncryptionConfigurationOutputReference | BigqueryJobLoadDestinationEncryptionConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryJobLoadDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobLoadDestinationEncryptionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobLoadDestinationEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryJobLoadDestinationTableToTerraform(struct?: BigqueryJobLoadDestinationTableOutputReference | BigqueryJobLoadDestinationTable): any;
/**
 * @stability stable
 */
export declare class BigqueryJobLoadDestinationTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobLoadDestinationTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobLoadDestinationTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    resetDatasetId(): void;
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoadTimePartitioning {
    /**
     * Number of milliseconds for which to keep the storage for a partition.
     *
     * A wrapper is used here because 0 is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#expiration_ms BigqueryJob#expiration_ms}
     *
     * @stability stable
     */
    readonly expirationMs?: string;
    /**
     * If not set, the table is partitioned by pseudo column '_PARTITIONTIME';
     *
     * if set, the table is partitioned by this field.
     * The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
     * A wrapper is used here because an empty string is an invalid value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#field BigqueryJob#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * The only type supported is DAY, which will generate one partition per day.
     *
     * Providing an empty string used to cause an error,
     * but in OnePlatform the field will be treated as unset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#type BigqueryJob#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function bigqueryJobLoadTimePartitioningToTerraform(struct?: BigqueryJobLoadTimePartitioningOutputReference | BigqueryJobLoadTimePartitioning): any;
/**
 * @stability stable
 */
export declare class BigqueryJobLoadTimePartitioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobLoadTimePartitioning | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobLoadTimePartitioning | undefined);
    private _expirationMs?;
    /**
     * @stability stable
     */
    get expirationMs(): string;
    /**
     * @stability stable
     */
    set expirationMs(value: string);
    /**
     * @stability stable
     */
    resetExpirationMs(): void;
    /**
     * @stability stable
     */
    get expirationMsInput(): string | undefined;
    private _field?;
    /**
     * @stability stable
     */
    get field(): string;
    /**
     * @stability stable
     */
    set field(value: string);
    /**
     * @stability stable
     */
    resetField(): void;
    /**
     * @stability stable
     */
    get fieldInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobLoad {
    /**
     * Accept rows that are missing trailing optional columns.
     *
     * The missing values are treated as nulls.
     * If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
     * an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_jagged_rows BigqueryJob#allow_jagged_rows}
     *
     * @stability stable
     */
    readonly allowJaggedRows?: boolean | cdktf.IResolvable;
    /**
     * Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
     *
     * The default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_quoted_newlines BigqueryJob#allow_quoted_newlines}
     *
     * @stability stable
     */
    readonly allowQuotedNewlines?: boolean | cdktf.IResolvable;
    /**
     * Indicates if we should automatically infer the options and schema for CSV and JSON sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#autodetect BigqueryJob#autodetect}
     *
     * @stability stable
     */
    readonly autodetect?: boolean | cdktf.IResolvable;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * The character encoding of the data.
     *
     * The supported values are UTF-8 or ISO-8859-1.
     * The default value is UTF-8. BigQuery decodes the data after the raw, binary data
     * has been split using the values of the quote and fieldDelimiter properties.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#encoding BigqueryJob#encoding}
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * The separator for fields in a CSV file.
     *
     * The separator can be any ISO-8859-1 single-byte character.
     * To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
     * the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
     * data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator.
     * The default value is a comma (',').
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#field_delimiter BigqueryJob#field_delimiter}
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Indicates if BigQuery should allow extra values that are not represented in the table schema.
     *
     * If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
     * and if there are too many bad records, an invalid error is returned in the job result.
     * The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
     * CSV: Trailing columns
     * JSON: Named values that don't match any column names
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#ignore_unknown_values BigqueryJob#ignore_unknown_values}
     *
     * @stability stable
     */
    readonly ignoreUnknownValues?: boolean | cdktf.IResolvable;
    /**
     * The maximum number of bad records that BigQuery can ignore when running the job.
     *
     * If the number of bad records exceeds this value,
     * an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#max_bad_records BigqueryJob#max_bad_records}
     *
     * @stability stable
     */
    readonly maxBadRecords?: number;
    /**
     * Specifies a string that represents a null value in a CSV file.
     *
     * For example, if you specify "\N", BigQuery interprets "\N" as a null value
     * when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an
     * empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
     * an empty value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#null_marker BigqueryJob#null_marker}
     *
     * @stability stable
     */
    readonly nullMarker?: string;
    /**
     * If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
     *
     * Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
     * If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#projection_fields BigqueryJob#projection_fields}
     *
     * @stability stable
     */
    readonly projectionFields?: string[];
    /**
     * The value that is used to quote data sections in a CSV file.
     *
     * BigQuery converts the string to ISO-8859-1 encoding,
     * and then uses the first byte of the encoded string to split the data in its raw, binary state.
     * The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
     * If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#quote BigqueryJob#quote}
     *
     * @stability stable
     */
    readonly quote?: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
     * For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#schema_update_options BigqueryJob#schema_update_options}
     *
     * @stability stable
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
     *
     * The default value is 0. This property is useful if you have header rows in the file that should be skipped.
     * When autodetect is on, the behavior is the following:
     * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
     * the row is read as data. Otherwise data is read starting from the second row.
     * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
     * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
     * row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#skip_leading_rows BigqueryJob#skip_leading_rows}
     *
     * @stability stable
     */
    readonly skipLeadingRows?: number;
    /**
     * The format of the data files.
     *
     * For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
     * For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
     * For orc, specify "ORC". [Beta] For Bigtable, specify "BIGTABLE".
     * The default value is CSV.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#source_format BigqueryJob#source_format}
     *
     * @stability stable
     */
    readonly sourceFormat?: string;
    /**
     * The fully-qualified URIs that point to your data in Google Cloud.
     *
     * For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
     * and it must come after the 'bucket' name. Size limits related to load jobs apply
     * to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
     * specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
     * For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#source_uris BigqueryJob#source_uris}
     *
     * @stability stable
     */
    readonly sourceUris: string[];
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobLoadDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable: BigqueryJobLoadDestinationTable;
    /**
     * time_partitioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#time_partitioning BigqueryJob#time_partitioning}
     *
     * @stability stable
     */
    readonly timePartitioning?: BigqueryJobLoadTimePartitioning;
}
export declare function bigqueryJobLoadToTerraform(struct?: BigqueryJobLoadOutputReference | BigqueryJobLoad): any;
/**
 * @stability stable
 */
export declare class BigqueryJobLoadOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobLoad | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobLoad | undefined);
    private _allowJaggedRows?;
    /**
     * @stability stable
     */
    get allowJaggedRows(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowJaggedRows(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowJaggedRows(): void;
    /**
     * @stability stable
     */
    get allowJaggedRowsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowQuotedNewlines?;
    /**
     * @stability stable
     */
    get allowQuotedNewlines(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowQuotedNewlines(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowQuotedNewlines(): void;
    /**
     * @stability stable
     */
    get allowQuotedNewlinesInput(): boolean | cdktf.IResolvable | undefined;
    private _autodetect?;
    /**
     * @stability stable
     */
    get autodetect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autodetect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutodetect(): void;
    /**
     * @stability stable
     */
    get autodetectInput(): boolean | cdktf.IResolvable | undefined;
    private _createDisposition?;
    /**
     * @stability stable
     */
    get createDisposition(): string;
    /**
     * @stability stable
     */
    set createDisposition(value: string);
    /**
     * @stability stable
     */
    resetCreateDisposition(): void;
    /**
     * @stability stable
     */
    get createDispositionInput(): string | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _ignoreUnknownValues?;
    /**
     * @stability stable
     */
    get ignoreUnknownValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreUnknownValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreUnknownValues(): void;
    /**
     * @stability stable
     */
    get ignoreUnknownValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBadRecords?;
    /**
     * @stability stable
     */
    get maxBadRecords(): number;
    /**
     * @stability stable
     */
    set maxBadRecords(value: number);
    /**
     * @stability stable
     */
    resetMaxBadRecords(): void;
    /**
     * @stability stable
     */
    get maxBadRecordsInput(): number | undefined;
    private _nullMarker?;
    /**
     * @stability stable
     */
    get nullMarker(): string;
    /**
     * @stability stable
     */
    set nullMarker(value: string);
    /**
     * @stability stable
     */
    resetNullMarker(): void;
    /**
     * @stability stable
     */
    get nullMarkerInput(): string | undefined;
    private _projectionFields?;
    /**
     * @stability stable
     */
    get projectionFields(): string[];
    /**
     * @stability stable
     */
    set projectionFields(value: string[]);
    /**
     * @stability stable
     */
    resetProjectionFields(): void;
    /**
     * @stability stable
     */
    get projectionFieldsInput(): string[] | undefined;
    private _quote?;
    /**
     * @stability stable
     */
    get quote(): string;
    /**
     * @stability stable
     */
    set quote(value: string);
    /**
     * @stability stable
     */
    resetQuote(): void;
    /**
     * @stability stable
     */
    get quoteInput(): string | undefined;
    private _schemaUpdateOptions?;
    /**
     * @stability stable
     */
    get schemaUpdateOptions(): string[];
    /**
     * @stability stable
     */
    set schemaUpdateOptions(value: string[]);
    /**
     * @stability stable
     */
    resetSchemaUpdateOptions(): void;
    /**
     * @stability stable
     */
    get schemaUpdateOptionsInput(): string[] | undefined;
    private _skipLeadingRows?;
    /**
     * @stability stable
     */
    get skipLeadingRows(): number;
    /**
     * @stability stable
     */
    set skipLeadingRows(value: number);
    /**
     * @stability stable
     */
    resetSkipLeadingRows(): void;
    /**
     * @stability stable
     */
    get skipLeadingRowsInput(): number | undefined;
    private _sourceFormat?;
    /**
     * @stability stable
     */
    get sourceFormat(): string;
    /**
     * @stability stable
     */
    set sourceFormat(value: string);
    /**
     * @stability stable
     */
    resetSourceFormat(): void;
    /**
     * @stability stable
     */
    get sourceFormatInput(): string | undefined;
    private _sourceUris?;
    /**
     * @stability stable
     */
    get sourceUris(): string[];
    /**
     * @stability stable
     */
    set sourceUris(value: string[]);
    /**
     * @stability stable
     */
    get sourceUrisInput(): string[] | undefined;
    private _writeDisposition?;
    /**
     * @stability stable
     */
    get writeDisposition(): string;
    /**
     * @stability stable
     */
    set writeDisposition(value: string);
    /**
     * @stability stable
     */
    resetWriteDisposition(): void;
    /**
     * @stability stable
     */
    get writeDispositionInput(): string | undefined;
    private _destinationEncryptionConfiguration;
    /**
     * @stability stable
     */
    get destinationEncryptionConfiguration(): BigqueryJobLoadDestinationEncryptionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putDestinationEncryptionConfiguration(value: BigqueryJobLoadDestinationEncryptionConfiguration): void;
    /**
     * @stability stable
     */
    resetDestinationEncryptionConfiguration(): void;
    /**
     * @stability stable
     */
    get destinationEncryptionConfigurationInput(): BigqueryJobLoadDestinationEncryptionConfiguration | undefined;
    private _destinationTable;
    /**
     * @stability stable
     */
    get destinationTable(): BigqueryJobLoadDestinationTableOutputReference;
    /**
     * @stability stable
     */
    putDestinationTable(value: BigqueryJobLoadDestinationTable): void;
    /**
     * @stability stable
     */
    get destinationTableInput(): BigqueryJobLoadDestinationTable | undefined;
    private _timePartitioning;
    /**
     * @stability stable
     */
    get timePartitioning(): BigqueryJobLoadTimePartitioningOutputReference;
    /**
     * @stability stable
     */
    putTimePartitioning(value: BigqueryJobLoadTimePartitioning): void;
    /**
     * @stability stable
     */
    resetTimePartitioning(): void;
    /**
     * @stability stable
     */
    get timePartitioningInput(): BigqueryJobLoadTimePartitioning | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDefaultDataset {
    /**
     * The dataset. Can be specified '{{dataset_id}}' if 'project_id' is also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
}
export declare function bigqueryJobQueryDefaultDatasetToTerraform(struct?: BigqueryJobQueryDefaultDatasetOutputReference | BigqueryJobQueryDefaultDataset): any;
/**
 * @stability stable
 */
export declare class BigqueryJobQueryDefaultDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobQueryDefaultDataset | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobQueryDefaultDataset | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDestinationEncryptionConfiguration {
    /**
     * Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
     *
     * The BigQuery Service Account associated with your project requires access to this encryption key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#kms_key_name BigqueryJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
export declare function bigqueryJobQueryDestinationEncryptionConfigurationToTerraform(struct?: BigqueryJobQueryDestinationEncryptionConfigurationOutputReference | BigqueryJobQueryDestinationEncryptionConfiguration): any;
/**
 * @stability stable
 */
export declare class BigqueryJobQueryDestinationEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobQueryDestinationEncryptionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobQueryDestinationEncryptionConfiguration | undefined);
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryDestinationTable {
    /**
     * The ID of the dataset containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#dataset_id BigqueryJob#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId?: string;
    /**
     * The ID of the project containing this table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#project_id BigqueryJob#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#table_id BigqueryJob#table_id}
     *
     * @stability stable
     */
    readonly tableId: string;
}
export declare function bigqueryJobQueryDestinationTableToTerraform(struct?: BigqueryJobQueryDestinationTableOutputReference | BigqueryJobQueryDestinationTable): any;
/**
 * @stability stable
 */
export declare class BigqueryJobQueryDestinationTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobQueryDestinationTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobQueryDestinationTable | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    resetDatasetId(): void;
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _tableId?;
    /**
     * @stability stable
     */
    get tableId(): string;
    /**
     * @stability stable
     */
    set tableId(value: string);
    /**
     * @stability stable
     */
    get tableIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryScriptOptions {
    /**
     * Determines which statement in the script represents the "key result", used to populate the schema and query results of the script job.
     *
     * Possible values: ["LAST", "FIRST_SELECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#key_result_statement BigqueryJob#key_result_statement}
     *
     * @stability stable
     */
    readonly keyResultStatement?: string;
    /**
     * Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#statement_byte_budget BigqueryJob#statement_byte_budget}
     *
     * @stability stable
     */
    readonly statementByteBudget?: string;
    /**
     * Timeout period for each statement in a script.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#statement_timeout_ms BigqueryJob#statement_timeout_ms}
     *
     * @stability stable
     */
    readonly statementTimeoutMs?: string;
}
export declare function bigqueryJobQueryScriptOptionsToTerraform(struct?: BigqueryJobQueryScriptOptionsOutputReference | BigqueryJobQueryScriptOptions): any;
/**
 * @stability stable
 */
export declare class BigqueryJobQueryScriptOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobQueryScriptOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobQueryScriptOptions | undefined);
    private _keyResultStatement?;
    /**
     * @stability stable
     */
    get keyResultStatement(): string;
    /**
     * @stability stable
     */
    set keyResultStatement(value: string);
    /**
     * @stability stable
     */
    resetKeyResultStatement(): void;
    /**
     * @stability stable
     */
    get keyResultStatementInput(): string | undefined;
    private _statementByteBudget?;
    /**
     * @stability stable
     */
    get statementByteBudget(): string;
    /**
     * @stability stable
     */
    set statementByteBudget(value: string);
    /**
     * @stability stable
     */
    resetStatementByteBudget(): void;
    /**
     * @stability stable
     */
    get statementByteBudgetInput(): string | undefined;
    private _statementTimeoutMs?;
    /**
     * @stability stable
     */
    get statementTimeoutMs(): string;
    /**
     * @stability stable
     */
    set statementTimeoutMs(value: string);
    /**
     * @stability stable
     */
    resetStatementTimeoutMs(): void;
    /**
     * @stability stable
     */
    get statementTimeoutMsInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobQueryUserDefinedFunctionResources {
    /**
     * An inline resource that contains code for a user-defined function (UDF).
     *
     * Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#inline_code BigqueryJob#inline_code}
     *
     * @stability stable
     */
    readonly inlineCode?: string;
    /**
     * A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#resource_uri BigqueryJob#resource_uri}
     *
     * @stability stable
     */
    readonly resourceUri?: string;
}
export declare function bigqueryJobQueryUserDefinedFunctionResourcesToTerraform(struct?: BigqueryJobQueryUserDefinedFunctionResources): any;
/**
 * @stability stable
 */
export interface BigqueryJobQuery {
    /**
     * If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
     *
     * Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
     * However, you must still set destinationTable when result size exceeds the allowed maximum response size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#allow_large_results BigqueryJob#allow_large_results}
     *
     * @stability stable
     */
    readonly allowLargeResults?: boolean | cdktf.IResolvable;
    /**
     * Specifies whether the job is allowed to create new tables.
     *
     * The following values are supported:
     * CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
     * CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
     * Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#create_disposition BigqueryJob#create_disposition}
     *
     * @stability stable
     */
    readonly createDisposition?: string;
    /**
     * If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
     *
     * allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#flatten_results BigqueryJob#flatten_results}
     *
     * @stability stable
     */
    readonly flattenResults?: boolean | cdktf.IResolvable;
    /**
     * Limits the billing tier for this job.
     *
     * Queries that have resource usage beyond this tier will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_billing_tier BigqueryJob#maximum_billing_tier}
     *
     * @stability stable
     */
    readonly maximumBillingTier?: number;
    /**
     * Limits the bytes billed for this job.
     *
     * Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
     * If unspecified, this will be set to your project default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#maximum_bytes_billed BigqueryJob#maximum_bytes_billed}
     *
     * @stability stable
     */
    readonly maximumBytesBilled?: string;
    /**
     * Standard SQL only.
     *
     * Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#parameter_mode BigqueryJob#parameter_mode}
     *
     * @stability stable
     */
    readonly parameterMode?: string;
    /**
     * Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#priority BigqueryJob#priority}
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * SQL query text to execute.
     *
     * The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
     * NOTE*: queries containing [DML language](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
     * ('DELETE', 'UPDATE', 'MERGE', 'INSERT') must specify 'create_disposition = ""' and 'write_disposition = ""'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#query BigqueryJob#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * Allows the schema of the destination table to be updated as a side effect of the query job.
     *
     * Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
     * when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
     * specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
     * One or more of the following values are specified:
     * ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
     * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#schema_update_options BigqueryJob#schema_update_options}
     *
     * @stability stable
     */
    readonly schemaUpdateOptions?: string[];
    /**
     * Specifies whether to use BigQuery's legacy SQL dialect for this query.
     *
     * The default value is true.
     * If set to false, the query will use BigQuery's standard SQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_legacy_sql BigqueryJob#use_legacy_sql}
     *
     * @stability stable
     */
    readonly useLegacySql?: boolean | cdktf.IResolvable;
    /**
     * Whether to look for the result in the query cache.
     *
     * The query cache is a best-effort cache that will be flushed whenever
     * tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
     * The default value is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#use_query_cache BigqueryJob#use_query_cache}
     *
     * @stability stable
     */
    readonly useQueryCache?: boolean | cdktf.IResolvable;
    /**
     * Specifies the action that occurs if the destination table already exists.
     *
     * The following values are supported:
     * WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
     * WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
     * WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
     * Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
     * Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#write_disposition BigqueryJob#write_disposition}
     *
     * @stability stable
     */
    readonly writeDisposition?: string;
    /**
     * default_dataset block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#default_dataset BigqueryJob#default_dataset}
     *
     * @stability stable
     */
    readonly defaultDataset?: BigqueryJobQueryDefaultDataset;
    /**
     * destination_encryption_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_encryption_configuration BigqueryJob#destination_encryption_configuration}
     *
     * @stability stable
     */
    readonly destinationEncryptionConfiguration?: BigqueryJobQueryDestinationEncryptionConfiguration;
    /**
     * destination_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#destination_table BigqueryJob#destination_table}
     *
     * @stability stable
     */
    readonly destinationTable?: BigqueryJobQueryDestinationTable;
    /**
     * script_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#script_options BigqueryJob#script_options}
     *
     * @stability stable
     */
    readonly scriptOptions?: BigqueryJobQueryScriptOptions;
    /**
     * user_defined_function_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#user_defined_function_resources BigqueryJob#user_defined_function_resources}
     *
     * @stability stable
     */
    readonly userDefinedFunctionResources?: BigqueryJobQueryUserDefinedFunctionResources[];
}
export declare function bigqueryJobQueryToTerraform(struct?: BigqueryJobQueryOutputReference | BigqueryJobQuery): any;
/**
 * @stability stable
 */
export declare class BigqueryJobQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobQuery | undefined);
    private _allowLargeResults?;
    /**
     * @stability stable
     */
    get allowLargeResults(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowLargeResults(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowLargeResults(): void;
    /**
     * @stability stable
     */
    get allowLargeResultsInput(): boolean | cdktf.IResolvable | undefined;
    private _createDisposition?;
    /**
     * @stability stable
     */
    get createDisposition(): string;
    /**
     * @stability stable
     */
    set createDisposition(value: string);
    /**
     * @stability stable
     */
    resetCreateDisposition(): void;
    /**
     * @stability stable
     */
    get createDispositionInput(): string | undefined;
    private _flattenResults?;
    /**
     * @stability stable
     */
    get flattenResults(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set flattenResults(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFlattenResults(): void;
    /**
     * @stability stable
     */
    get flattenResultsInput(): boolean | cdktf.IResolvable | undefined;
    private _maximumBillingTier?;
    /**
     * @stability stable
     */
    get maximumBillingTier(): number;
    /**
     * @stability stable
     */
    set maximumBillingTier(value: number);
    /**
     * @stability stable
     */
    resetMaximumBillingTier(): void;
    /**
     * @stability stable
     */
    get maximumBillingTierInput(): number | undefined;
    private _maximumBytesBilled?;
    /**
     * @stability stable
     */
    get maximumBytesBilled(): string;
    /**
     * @stability stable
     */
    set maximumBytesBilled(value: string);
    /**
     * @stability stable
     */
    resetMaximumBytesBilled(): void;
    /**
     * @stability stable
     */
    get maximumBytesBilledInput(): string | undefined;
    private _parameterMode?;
    /**
     * @stability stable
     */
    get parameterMode(): string;
    /**
     * @stability stable
     */
    set parameterMode(value: string);
    /**
     * @stability stable
     */
    resetParameterMode(): void;
    /**
     * @stability stable
     */
    get parameterModeInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
    private _schemaUpdateOptions?;
    /**
     * @stability stable
     */
    get schemaUpdateOptions(): string[];
    /**
     * @stability stable
     */
    set schemaUpdateOptions(value: string[]);
    /**
     * @stability stable
     */
    resetSchemaUpdateOptions(): void;
    /**
     * @stability stable
     */
    get schemaUpdateOptionsInput(): string[] | undefined;
    private _useLegacySql?;
    /**
     * @stability stable
     */
    get useLegacySql(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useLegacySql(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseLegacySql(): void;
    /**
     * @stability stable
     */
    get useLegacySqlInput(): boolean | cdktf.IResolvable | undefined;
    private _useQueryCache?;
    /**
     * @stability stable
     */
    get useQueryCache(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useQueryCache(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseQueryCache(): void;
    /**
     * @stability stable
     */
    get useQueryCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _writeDisposition?;
    /**
     * @stability stable
     */
    get writeDisposition(): string;
    /**
     * @stability stable
     */
    set writeDisposition(value: string);
    /**
     * @stability stable
     */
    resetWriteDisposition(): void;
    /**
     * @stability stable
     */
    get writeDispositionInput(): string | undefined;
    private _defaultDataset;
    /**
     * @stability stable
     */
    get defaultDataset(): BigqueryJobQueryDefaultDatasetOutputReference;
    /**
     * @stability stable
     */
    putDefaultDataset(value: BigqueryJobQueryDefaultDataset): void;
    /**
     * @stability stable
     */
    resetDefaultDataset(): void;
    /**
     * @stability stable
     */
    get defaultDatasetInput(): BigqueryJobQueryDefaultDataset | undefined;
    private _destinationEncryptionConfiguration;
    /**
     * @stability stable
     */
    get destinationEncryptionConfiguration(): BigqueryJobQueryDestinationEncryptionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putDestinationEncryptionConfiguration(value: BigqueryJobQueryDestinationEncryptionConfiguration): void;
    /**
     * @stability stable
     */
    resetDestinationEncryptionConfiguration(): void;
    /**
     * @stability stable
     */
    get destinationEncryptionConfigurationInput(): BigqueryJobQueryDestinationEncryptionConfiguration | undefined;
    private _destinationTable;
    /**
     * @stability stable
     */
    get destinationTable(): BigqueryJobQueryDestinationTableOutputReference;
    /**
     * @stability stable
     */
    putDestinationTable(value: BigqueryJobQueryDestinationTable): void;
    /**
     * @stability stable
     */
    resetDestinationTable(): void;
    /**
     * @stability stable
     */
    get destinationTableInput(): BigqueryJobQueryDestinationTable | undefined;
    private _scriptOptions;
    /**
     * @stability stable
     */
    get scriptOptions(): BigqueryJobQueryScriptOptionsOutputReference;
    /**
     * @stability stable
     */
    putScriptOptions(value: BigqueryJobQueryScriptOptions): void;
    /**
     * @stability stable
     */
    resetScriptOptions(): void;
    /**
     * @stability stable
     */
    get scriptOptionsInput(): BigqueryJobQueryScriptOptions | undefined;
    private _userDefinedFunctionResources?;
    /**
     * @stability stable
     */
    get userDefinedFunctionResources(): BigqueryJobQueryUserDefinedFunctionResources[];
    /**
     * @stability stable
     */
    set userDefinedFunctionResources(value: BigqueryJobQueryUserDefinedFunctionResources[]);
    /**
     * @stability stable
     */
    resetUserDefinedFunctionResources(): void;
    /**
     * @stability stable
     */
    get userDefinedFunctionResourcesInput(): BigqueryJobQueryUserDefinedFunctionResources[] | undefined;
}
/**
 * @stability stable
 */
export interface BigqueryJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#create BigqueryJob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_job#delete BigqueryJob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function bigqueryJobTimeoutsToTerraform(struct?: BigqueryJobTimeoutsOutputReference | BigqueryJobTimeouts): any;
/**
 * @stability stable
 */
export declare class BigqueryJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryJobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_job google_bigquery_job}.
 *
 * @stability stable
 */
export declare class BigqueryJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_job google_bigquery_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryJobConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _jobId?;
    /**
     * @stability stable
     */
    get jobId(): string;
    /**
     * @stability stable
     */
    set jobId(value: string);
    /**
     * @stability stable
     */
    get jobIdInput(): string | undefined;
    private _jobTimeoutMs?;
    /**
     * @stability stable
     */
    get jobTimeoutMs(): string;
    /**
     * @stability stable
     */
    set jobTimeoutMs(value: string);
    /**
     * @stability stable
     */
    resetJobTimeoutMs(): void;
    /**
     * @stability stable
     */
    get jobTimeoutMsInput(): string | undefined;
    /**
     * @stability stable
     */
    get jobType(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    status(index: string): BigqueryJobStatus;
    /**
     * @stability stable
     */
    get userEmail(): string;
    private _copy;
    /**
     * @stability stable
     */
    get copy(): BigqueryJobCopyOutputReference;
    /**
     * @stability stable
     */
    putCopy(value: BigqueryJobCopy): void;
    /**
     * @stability stable
     */
    resetCopy(): void;
    /**
     * @stability stable
     */
    get copyInput(): BigqueryJobCopy | undefined;
    private _extract;
    /**
     * @stability stable
     */
    get extract(): BigqueryJobExtractOutputReference;
    /**
     * @stability stable
     */
    putExtract(value: BigqueryJobExtract): void;
    /**
     * @stability stable
     */
    resetExtract(): void;
    /**
     * @stability stable
     */
    get extractInput(): BigqueryJobExtract | undefined;
    private _load;
    /**
     * @stability stable
     */
    get load(): BigqueryJobLoadOutputReference;
    /**
     * @stability stable
     */
    putLoad(value: BigqueryJobLoad): void;
    /**
     * @stability stable
     */
    resetLoad(): void;
    /**
     * @stability stable
     */
    get loadInput(): BigqueryJobLoad | undefined;
    private _query;
    /**
     * @stability stable
     */
    get query(): BigqueryJobQueryOutputReference;
    /**
     * @stability stable
     */
    putQuery(value: BigqueryJobQuery): void;
    /**
     * @stability stable
     */
    resetQuery(): void;
    /**
     * @stability stable
     */
    get queryInput(): BigqueryJobQuery | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigqueryJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
