import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BillingAccountIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_policy#billing_account_id BillingAccountIamPolicy#billing_account_id}.
     *
     * @stability stable
     */
    readonly billingAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_policy#policy_data BillingAccountIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_policy google_billing_account_iam_policy}.
 *
 * @stability stable
 */
export declare class BillingAccountIamPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_policy google_billing_account_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BillingAccountIamPolicyConfig);
    private _billingAccountId?;
    /**
     * @stability stable
     */
    get billingAccountId(): string;
    /**
     * @stability stable
     */
    set billingAccountId(value: string);
    /**
     * @stability stable
     */
    get billingAccountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData?;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
