import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudIdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An extended description to help users determine the purpose of a Group. Must not be longer than 4,096 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#description CloudIdentityGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The display name of the Group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#display_name CloudIdentityGroup#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The initial configuration options for creating a Group.
     *
     * See the
     * [API reference](https://cloud.google.com/identity/docs/reference/rest/v1beta1/groups/create#initialgroupconfig)
     * for possible values. Default value: "EMPTY" Possible values: ["INITIAL_GROUP_CONFIG_UNSPECIFIED", "WITH_INITIAL_OWNER", "EMPTY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#initial_group_config CloudIdentityGroup#initial_group_config}
     *
     * @stability stable
     */
    readonly initialGroupConfig?: string;
    /**
     * The labels that apply to the Group.
     *
     * Must not contain more than one entry. Must contain the entry
     * 'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
     * 'system/groups/external': '' if the Group is an external-identity-mapped group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#labels CloudIdentityGroup#labels}
     *
     * @stability stable
     */
    readonly labels: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name of the entity under which this Group resides in the Cloud Identity resource hierarchy.
     *
     * Must be of the form identitysources/{identity_source_id} for external-identity-mapped
     * groups or customers/{customer_id} for Google Groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#parent CloudIdentityGroup#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * group_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#group_key CloudIdentityGroup#group_key}
     *
     * @stability stable
     */
    readonly groupKey: CloudIdentityGroupGroupKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#timeouts CloudIdentityGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudIdentityGroupTimeouts;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupGroupKey {
    /**
     * The ID of the entity.
     *
     * For Google-managed entities, the id must be the email address of an existing
     * group or user.
     *
     * For external-identity-mapped entities, the id must be a string conforming
     * to the Identity Source's requirements.
     *
     * Must be unique within a namespace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#id CloudIdentityGroup#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The namespace in which the entity exists.
     *
     * If not specified, the EntityKey represents a Google-managed entity
     * such as a Google user or a Google Group.
     *
     * If specified, the EntityKey represents an external-identity-mapped group.
     * The namespace must correspond to an identity source created in Admin Console
     * and must be in the form of 'identitysources/{identity_source_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#namespace CloudIdentityGroup#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
}
export declare function cloudIdentityGroupGroupKeyToTerraform(struct?: CloudIdentityGroupGroupKeyOutputReference | CloudIdentityGroupGroupKey): any;
/**
 * @stability stable
 */
export declare class CloudIdentityGroupGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudIdentityGroupGroupKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudIdentityGroupGroupKey | undefined);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudIdentityGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#create CloudIdentityGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#delete CloudIdentityGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group#update CloudIdentityGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudIdentityGroupTimeoutsToTerraform(struct?: CloudIdentityGroupTimeoutsOutputReference | CloudIdentityGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class CloudIdentityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudIdentityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudIdentityGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group google_cloud_identity_group}.
 *
 * @stability stable
 */
export declare class CloudIdentityGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_identity_group google_cloud_identity_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudIdentityGroupConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialGroupConfig?;
    /**
     * @stability stable
     */
    get initialGroupConfig(): string;
    /**
     * @stability stable
     */
    set initialGroupConfig(value: string);
    /**
     * @stability stable
     */
    resetInitialGroupConfig(): void;
    /**
     * @stability stable
     */
    get initialGroupConfigInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _groupKey;
    /**
     * @stability stable
     */
    get groupKey(): CloudIdentityGroupGroupKeyOutputReference;
    /**
     * @stability stable
     */
    putGroupKey(value: CloudIdentityGroupGroupKey): void;
    /**
     * @stability stable
     */
    get groupKeyInput(): CloudIdentityGroupGroupKey | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudIdentityGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudIdentityGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudIdentityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
