import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-defined labels for this environment.
     *
     * The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: Label keys must be between 1 and 63 characters long and must conform to the following regular expression: [a-z]([-a-z0-9]*[a-z0-9])?. Label values must be between 0 and 63 characters long and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?. No more than 64 labels can be associated with a given environment. Both keys and values must be <= 128 bytes in size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#labels ComposerEnvironment#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#name ComposerEnvironment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#project ComposerEnvironment#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The location or Compute Engine region for the environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#region ComposerEnvironment#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#config ComposerEnvironment#config}
     *
     * @stability stable
     */
    readonly config?: ComposerEnvironmentConfigA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#timeouts ComposerEnvironment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComposerEnvironmentTimeouts;
}
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfigNodeConfigIpAllocationPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cluster_ipv4_cidr_block ComposerEnvironment#cluster_ipv4_cidr_block}.
     *
     * @stability stable
     */
    readonly clusterIpv4CidrBlock?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cluster_secondary_range_name ComposerEnvironment#cluster_secondary_range_name}.
     *
     * @stability stable
     */
    readonly clusterSecondaryRangeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#services_ipv4_cidr_block ComposerEnvironment#services_ipv4_cidr_block}.
     *
     * @stability stable
     */
    readonly servicesIpv4CidrBlock?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#services_secondary_range_name ComposerEnvironment#services_secondary_range_name}.
     *
     * @stability stable
     */
    readonly servicesSecondaryRangeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#use_ip_aliases ComposerEnvironment#use_ip_aliases}.
     *
     * @stability stable
     */
    readonly useIpAliases?: boolean | cdktf.IResolvable;
}
export declare function composerEnvironmentConfigNodeConfigIpAllocationPolicyToTerraform(struct?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy): any;
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfigNodeConfig {
    /**
     * The disk size in GB used for node VMs.
     *
     * Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#disk_size_gb ComposerEnvironment#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#ip_allocation_policy ComposerEnvironment#ip_allocation_policy}
     *
     * @stability stable
     */
    readonly ipAllocationPolicy?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[];
    /**
     * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name.
     *
     * For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#machine_type ComposerEnvironment#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name.
     *
     * For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#network ComposerEnvironment#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The set of Google API scopes to be made available on all node VMs.
     *
     * Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#oauth_scopes ComposerEnvironment#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#service_account ComposerEnvironment#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The Compute Engine subnetwork to be used for machine communications, , specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#subnetwork ComposerEnvironment#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * The list of instance tags applied to all node VMs.
     *
     * Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#tags ComposerEnvironment#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#zone ComposerEnvironment#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
export declare function composerEnvironmentConfigNodeConfigToTerraform(struct?: ComposerEnvironmentConfigNodeConfigOutputReference | ComposerEnvironmentConfigNodeConfig): any;
/**
 * @stability stable
 */
export declare class ComposerEnvironmentConfigNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComposerEnvironmentConfigNodeConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComposerEnvironmentConfigNodeConfig | undefined);
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _ipAllocationPolicy?;
    /**
     * @stability stable
     */
    get ipAllocationPolicy(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[];
    /**
     * @stability stable
     */
    set ipAllocationPolicy(value: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[]);
    /**
     * @stability stable
     */
    resetIpAllocationPolicy(): void;
    /**
     * @stability stable
     */
    get ipAllocationPolicyInput(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfigPrivateEnvironmentConfig {
    /**
     * The CIDR block from which IP range in tenant project will be reserved for Cloud SQL.
     *
     * Needs to be disjoint from web_server_ipv4_cidr_block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cloud_sql_ipv4_cidr_block ComposerEnvironment#cloud_sql_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly cloudSqlIpv4CidrBlock?: string;
    /**
     * If true, access to the public endpoint of the GKE cluster is denied.
     *
     * If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enable_private_endpoint ComposerEnvironment#enable_private_endpoint}
     *
     * @stability stable
     */
    readonly enablePrivateEndpoint?: boolean | cdktf.IResolvable;
    /**
     * The IP range in CIDR notation to use for the hosted master network.
     *
     * This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#master_ipv4_cidr_block ComposerEnvironment#master_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly masterIpv4CidrBlock?: string;
    /**
     * The CIDR block from which IP range for web server will be reserved.
     *
     * Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#web_server_ipv4_cidr_block ComposerEnvironment#web_server_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly webServerIpv4CidrBlock?: string;
}
export declare function composerEnvironmentConfigPrivateEnvironmentConfigToTerraform(struct?: ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference | ComposerEnvironmentConfigPrivateEnvironmentConfig): any;
/**
 * @stability stable
 */
export declare class ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined);
    private _cloudSqlIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get cloudSqlIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set cloudSqlIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetCloudSqlIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get cloudSqlIpv4CidrBlockInput(): string | undefined;
    private _enablePrivateEndpoint?;
    /**
     * @stability stable
     */
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePrivateEndpoint(): void;
    /**
     * @stability stable
     */
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set masterIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetMasterIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlockInput(): string | undefined;
    private _webServerIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get webServerIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set webServerIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetWebServerIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get webServerIpv4CidrBlockInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfigSoftwareConfig {
    /**
     * Apache Airflow configuration properties to override.
     *
     * Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#airflow_config_overrides ComposerEnvironment#airflow_config_overrides}
     *
     * @stability stable
     */
    readonly airflowConfigOverrides?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Additional environment variables to provide to the Apache Airflow schedulerf, worker, and webserver processes.
     *
     * Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#env_variables ComposerEnvironment#env_variables}
     *
     * @stability stable
     */
    readonly envVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The version of the software running in the environment.
     *
     * This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-[0-9]+\.[0-9]+(\.[0-9]+)?-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?. The Cloud Composer portion of the version is a semantic version. The portion of the image version following 'airflow-' is an official Apache Airflow repository release name. See documentation for allowed release names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#image_version ComposerEnvironment#image_version}
     *
     * @stability stable
     */
    readonly imageVersion?: string;
    /**
     * Custom Python Package Index (PyPI) packages to be installed in the environment.
     *
     * Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#pypi_packages ComposerEnvironment#pypi_packages}
     *
     * @stability stable
     */
    readonly pypiPackages?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes.
     *
     * Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#python_version ComposerEnvironment#python_version}
     *
     * @stability stable
     */
    readonly pythonVersion?: string;
    /**
     * The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#scheduler_count ComposerEnvironment#scheduler_count}
     *
     * @stability stable
     */
    readonly schedulerCount?: number;
}
export declare function composerEnvironmentConfigSoftwareConfigToTerraform(struct?: ComposerEnvironmentConfigSoftwareConfigOutputReference | ComposerEnvironmentConfigSoftwareConfig): any;
/**
 * @stability stable
 */
export declare class ComposerEnvironmentConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComposerEnvironmentConfigSoftwareConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComposerEnvironmentConfigSoftwareConfig | undefined);
    private _airflowConfigOverrides?;
    /**
     * @stability stable
     */
    get airflowConfigOverrides(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set airflowConfigOverrides(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAirflowConfigOverrides(): void;
    /**
     * @stability stable
     */
    get airflowConfigOverridesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _envVariables?;
    /**
     * @stability stable
     */
    get envVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set envVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvVariables(): void;
    /**
     * @stability stable
     */
    get envVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _imageVersion?;
    /**
     * @stability stable
     */
    get imageVersion(): string;
    /**
     * @stability stable
     */
    set imageVersion(value: string);
    /**
     * @stability stable
     */
    resetImageVersion(): void;
    /**
     * @stability stable
     */
    get imageVersionInput(): string | undefined;
    private _pypiPackages?;
    /**
     * @stability stable
     */
    get pypiPackages(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set pypiPackages(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPypiPackages(): void;
    /**
     * @stability stable
     */
    get pypiPackagesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pythonVersion?;
    /**
     * @stability stable
     */
    get pythonVersion(): string;
    /**
     * @stability stable
     */
    set pythonVersion(value: string);
    /**
     * @stability stable
     */
    resetPythonVersion(): void;
    /**
     * @stability stable
     */
    get pythonVersionInput(): string | undefined;
    private _schedulerCount?;
    /**
     * @stability stable
     */
    get schedulerCount(): number;
    /**
     * @stability stable
     */
    set schedulerCount(value: number);
    /**
     * @stability stable
     */
    resetSchedulerCount(): void;
    /**
     * @stability stable
     */
    get schedulerCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComposerEnvironmentConfigA {
    /**
     * The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
     *
     * This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#node_count ComposerEnvironment#node_count}
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#node_config ComposerEnvironment#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ComposerEnvironmentConfigNodeConfig;
    /**
     * private_environment_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#private_environment_config ComposerEnvironment#private_environment_config}
     *
     * @stability stable
     */
    readonly privateEnvironmentConfig?: ComposerEnvironmentConfigPrivateEnvironmentConfig;
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#software_config ComposerEnvironment#software_config}
     *
     * @stability stable
     */
    readonly softwareConfig?: ComposerEnvironmentConfigSoftwareConfig;
}
export declare function composerEnvironmentConfigAToTerraform(struct?: ComposerEnvironmentConfigAOutputReference | ComposerEnvironmentConfigA): any;
/**
 * @stability stable
 */
export declare class ComposerEnvironmentConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComposerEnvironmentConfigA | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComposerEnvironmentConfigA | undefined);
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeConfig;
    /**
     * @stability stable
     */
    get nodeConfig(): ComposerEnvironmentConfigNodeConfigOutputReference;
    /**
     * @stability stable
     */
    putNodeConfig(value: ComposerEnvironmentConfigNodeConfig): void;
    /**
     * @stability stable
     */
    resetNodeConfig(): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): ComposerEnvironmentConfigNodeConfig | undefined;
    private _privateEnvironmentConfig;
    /**
     * @stability stable
     */
    get privateEnvironmentConfig(): ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference;
    /**
     * @stability stable
     */
    putPrivateEnvironmentConfig(value: ComposerEnvironmentConfigPrivateEnvironmentConfig): void;
    /**
     * @stability stable
     */
    resetPrivateEnvironmentConfig(): void;
    /**
     * @stability stable
     */
    get privateEnvironmentConfigInput(): ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    private _softwareConfig;
    /**
     * @stability stable
     */
    get softwareConfig(): ComposerEnvironmentConfigSoftwareConfigOutputReference;
    /**
     * @stability stable
     */
    putSoftwareConfig(value: ComposerEnvironmentConfigSoftwareConfig): void;
    /**
     * @stability stable
     */
    resetSoftwareConfig(): void;
    /**
     * @stability stable
     */
    get softwareConfigInput(): ComposerEnvironmentConfigSoftwareConfig | undefined;
}
/**
 * @stability stable
 */
export interface ComposerEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#create ComposerEnvironment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#delete ComposerEnvironment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#update ComposerEnvironment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function composerEnvironmentTimeoutsToTerraform(struct?: ComposerEnvironmentTimeoutsOutputReference | ComposerEnvironmentTimeouts): any;
/**
 * @stability stable
 */
export declare class ComposerEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComposerEnvironmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComposerEnvironmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/composer_environment google_composer_environment}.
 *
 * @stability stable
 */
export declare class ComposerEnvironment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/composer_environment google_composer_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComposerEnvironmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _config;
    /**
     * @stability stable
     */
    get config(): ComposerEnvironmentConfigAOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: ComposerEnvironmentConfigA): void;
    /**
     * @stability stable
     */
    resetConfig(): void;
    /**
     * @stability stable
     */
    get configInput(): ComposerEnvironmentConfigA | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComposerEnvironmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComposerEnvironmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComposerEnvironmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
