import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#bucket_name ComputeBackendBucket#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * Headers that the HTTP/S load balancer should add to proxied responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#custom_response_headers ComputeBackendBucket#custom_response_headers}
     *
     * @stability stable
     */
    readonly customResponseHeaders?: string[];
    /**
     * An optional textual description of the resource; provided by the client when the resource is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#description ComputeBackendBucket#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this BackendBucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#enable_cdn ComputeBackendBucket#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#name ComputeBackendBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#project ComputeBackendBucket#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#cdn_policy ComputeBackendBucket#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeBackendBucketCdnPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#timeouts ComputeBackendBucket#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBackendBucketTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeBackendBucketCdnPolicyNegativeCachingPolicy {
    /**
     * The HTTP status code to define a TTL against.
     *
     * Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
     * can be specified as values, and you cannot specify a status code more than once.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#code ComputeBackendBucket#code}
     *
     * @stability stable
     */
    readonly code?: number;
    /**
     * The TTL (in seconds) for which to cache responses with the corresponding status code.
     *
     * The maximum allowed value is 1800s
     * (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#ttl ComputeBackendBucket#ttl}
     *
     * @stability stable
     */
    readonly ttl?: number;
}
export declare function computeBackendBucketCdnPolicyNegativeCachingPolicyToTerraform(struct?: ComputeBackendBucketCdnPolicyNegativeCachingPolicy): any;
/**
 * @stability stable
 */
export interface ComputeBackendBucketCdnPolicy {
    /**
     * Specifies the cache setting for all responses from this backend.
     *
     * The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#cache_mode ComputeBackendBucket#cache_mode}
     *
     * @stability stable
     */
    readonly cacheMode?: string;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#client_ttl ComputeBackendBucket#client_ttl}
     *
     * @stability stable
     */
    readonly clientTtl?: number;
    /**
     * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#default_ttl ComputeBackendBucket#default_ttl}
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#max_ttl ComputeBackendBucket#max_ttl}
     *
     * @stability stable
     */
    readonly maxTtl?: number;
    /**
     * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#negative_caching ComputeBackendBucket#negative_caching}
     *
     * @stability stable
     */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
     * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#serve_while_stale ComputeBackendBucket#serve_while_stale}
     *
     * @stability stable
     */
    readonly serveWhileStale?: number;
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh.
     *
     * After this time period,
     * the response will be revalidated before being served.
     * When serving responses to signed URL requests,
     * Cloud CDN will internally behave as though
     * all responses from this backend had a "Cache-Control: public,
     * max-age=[TTL]" header, regardless of any existing Cache-Control
     * header. The actual headers served in responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#signed_url_cache_max_age_sec ComputeBackendBucket#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
     * negative_caching_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#negative_caching_policy ComputeBackendBucket#negative_caching_policy}
     *
     * @stability stable
     */
    readonly negativeCachingPolicy?: ComputeBackendBucketCdnPolicyNegativeCachingPolicy[];
}
export declare function computeBackendBucketCdnPolicyToTerraform(struct?: ComputeBackendBucketCdnPolicyOutputReference | ComputeBackendBucketCdnPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeBackendBucketCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendBucketCdnPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendBucketCdnPolicy | undefined);
    private _cacheMode?;
    /**
     * @stability stable
     */
    get cacheMode(): string;
    /**
     * @stability stable
     */
    set cacheMode(value: string);
    /**
     * @stability stable
     */
    resetCacheMode(): void;
    /**
     * @stability stable
     */
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    /**
     * @stability stable
     */
    get clientTtl(): number;
    /**
     * @stability stable
     */
    set clientTtl(value: number);
    /**
     * @stability stable
     */
    resetClientTtl(): void;
    /**
     * @stability stable
     */
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    set defaultTtl(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    /**
     * @stability stable
     */
    get maxTtl(): number;
    /**
     * @stability stable
     */
    set maxTtl(value: number);
    /**
     * @stability stable
     */
    resetMaxTtl(): void;
    /**
     * @stability stable
     */
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    /**
     * @stability stable
     */
    get negativeCaching(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set negativeCaching(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNegativeCaching(): void;
    /**
     * @stability stable
     */
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    /**
     * @stability stable
     */
    get serveWhileStale(): number;
    /**
     * @stability stable
     */
    set serveWhileStale(value: number);
    /**
     * @stability stable
     */
    resetServeWhileStale(): void;
    /**
     * @stability stable
     */
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSec(): number;
    /**
     * @stability stable
     */
    set signedUrlCacheMaxAgeSec(value: number);
    /**
     * @stability stable
     */
    resetSignedUrlCacheMaxAgeSec(): void;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _negativeCachingPolicy?;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): ComputeBackendBucketCdnPolicyNegativeCachingPolicy[];
    /**
     * @stability stable
     */
    set negativeCachingPolicy(value: ComputeBackendBucketCdnPolicyNegativeCachingPolicy[]);
    /**
     * @stability stable
     */
    resetNegativeCachingPolicy(): void;
    /**
     * @stability stable
     */
    get negativeCachingPolicyInput(): ComputeBackendBucketCdnPolicyNegativeCachingPolicy[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeBackendBucketTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#create ComputeBackendBucket#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#delete ComputeBackendBucket#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#update ComputeBackendBucket#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeBackendBucketTimeoutsToTerraform(struct?: ComputeBackendBucketTimeoutsOutputReference | ComputeBackendBucketTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeBackendBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeBackendBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeBackendBucketTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket google_compute_backend_bucket}.
 *
 * @stability stable
 */
export declare class ComputeBackendBucket extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket google_compute_backend_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBackendBucketConfig);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _customResponseHeaders?;
    /**
     * @stability stable
     */
    get customResponseHeaders(): string[];
    /**
     * @stability stable
     */
    set customResponseHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetCustomResponseHeaders(): void;
    /**
     * @stability stable
     */
    get customResponseHeadersInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _cdnPolicy;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeBackendBucketCdnPolicyOutputReference;
    /**
     * @stability stable
     */
    putCdnPolicy(value: ComputeBackendBucketCdnPolicy): void;
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeBackendBucketCdnPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBackendBucketTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeBackendBucketTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBackendBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
